package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.ProductionTypeItemVO;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.production.bean.ProductionTypeEntity;
import com.ejianc.business.production.service.IProductionTypeService;
import com.ejianc.business.production.vo.ProductionTypeVO;

/**
 * 产权类型
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("productionType")
public class ProductionTypeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    private static final String BILL_CODE = "sddjs-productionType";//此处需要根据实际修改

    @Autowired
    private IProductionTypeService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionTypeVO> saveOrUpdate(@RequestBody ProductionTypeVO saveorUpdateVO) {
    	ProductionTypeEntity entity = BeanMapper.map(saveorUpdateVO, ProductionTypeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ProductionTypeVO vo = BeanMapper.map(entity, ProductionTypeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionTypeVO> queryDetail(Long id) {
    	ProductionTypeEntity entity = service.selectById(id);
    	ProductionTypeVO vo = BeanMapper.map(entity, ProductionTypeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionTypeVO> vos) {
        service.removeByIds(vos.stream().map(ProductionTypeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List<ProductionTypeEntity> dataList = service.queryList(param);

        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        if(dataList!=null&&dataList.size()>0){
            jsonObject.put("data", createTreeData(dataList));
        }
        return CommonResponse.success(jsonObject);
    }

    public static List<ProductionTypeEntity> createTreeData(List<ProductionTypeEntity> list) {
        List<ProductionTypeEntity> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, ProductionTypeEntity> listMap = new HashMap<>();
        for(ProductionTypeEntity vo:list) {
            listMap.put(vo.getId().toString(), vo);
        }

        for(int i =0; i<list.size(); i++) {
            ProductionTypeEntity productionTypeEntity = list.get(i);
            String parentId = (productionTypeEntity.getPid() != null && productionTypeEntity.getPid() > 0) ? productionTypeEntity.getPid().toString():"";
            ProductionTypeEntity parent = listMap.get(parentId);
            if(parent != null) {
                List<ProductionTypeEntity> child = parent.getChildren();
                if(child != null) {
                    child.add(productionTypeEntity);
                }else{
                    List<ProductionTypeEntity> children = new ArrayList<ProductionTypeEntity>();
                    children.add(productionTypeEntity);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(productionTypeEntity.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    public static List<ProductionTypeVO> createTreeDataVO(List<ProductionTypeVO> list) {
        List<ProductionTypeVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, ProductionTypeVO> listMap = new HashMap<>();
        for(ProductionTypeVO vo:list) {
            listMap.put(vo.getId().toString(), vo);
        }

        for(int i =0; i<list.size(); i++) {
            ProductionTypeVO vo = list.get(i);
            String parentId = (vo.getPid() != null && vo.getPid() > 0) ? vo.getPid().toString():"";
            ProductionTypeVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ProductionTypeVO> child = parent.getChildren();
                if(child != null) {
                    child.add(vo);
                }else{
                    List<ProductionTypeVO> children = new ArrayList<ProductionTypeVO>();
                    children.add(vo);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(vo.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }
        return resp;
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProductionTypeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProductionType-export.xlsx", beans, response);
    }

    /**
     * @Description 参
     * @Return void
     */
    @RequestMapping(value = "/refProductionTypeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProductionTypeVO>> refProductionTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProductionTypeEntity> page = service.queryPage(param,false);
        IPage<ProductionTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionTypeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 根据CODE 查询其下数据
     * @param id
     */
    @RequestMapping(value = "/queryListByCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProductionTypeVO>> queryListByCode(String code) {
        QueryParam param = new QueryParam();
        param.getParams().put("code",new Parameter(QueryParam.EQ,code));

        List<ProductionTypeEntity> list = service.queryList(param);

        if(ListUtil.isEmpty(list)){
            return CommonResponse.error("没有找到该类型产权登记!");
        }
        param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ,list.get(0).getId()));
        list = service.queryList(param);
        return CommonResponse.success("查询详情数据成功！",BeanMapper.mapList(list, ProductionTypeVO.class));
    }
}
