package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.ejianc.business.production.bean.ConformanceContentEntity;
import com.ejianc.business.production.service.IConformanceContentService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.ProductionTypeItemVO;

/**
 * 产权类型-上传档案项
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("productionTypeItem")
public class ProductionTypeItemController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConformanceContentService conformanceContentService;

    @Autowired
    private IProductionTypeItemService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionTypeItemVO> saveOrUpdate(@RequestBody ProductionTypeItemVO saveorUpdateVO) {
    	ProductionTypeItemEntity entity = BeanMapper.map(saveorUpdateVO, ProductionTypeItemEntity.class);
    	service.saveOrUpdate(entity, false);
    	ProductionTypeItemVO vo = BeanMapper.map(entity, ProductionTypeItemVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionTypeItemVO> queryDetail(Long id) {
    	ProductionTypeItemEntity entity = service.selectById(id);
    	ProductionTypeItemVO vo = BeanMapper.map(entity, ProductionTypeItemVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionTypeItemVO> vos) {
        QueryParam param = new QueryParam();
        param.getParams().put("fileSetId",new Parameter(QueryParam.IN,vos.stream().map(ProductionTypeItemVO::getId).collect(Collectors.toList())));
        List<ConformanceContentEntity> exist = conformanceContentService.queryList(param);
        if(ListUtil.isNotEmpty(exist)){
            return CommonResponse.error("删除失败！数据已被引用不允许删除："+ Strings.join(Lists.newArrayList(exist.stream().map(ConformanceContentEntity::getName).distinct().collect(Collectors.toList())), ','));
        }
        service.removeByIds(vos.stream().map(ProductionTypeItemVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param productionTypeId
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProductionTypeItemVO>> queryList(Long productionTypeId) {
        QueryParam param = new QueryParam();
        param.getParams().put("productionTypeId",new Parameter(QueryParam.EQ,productionTypeId));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
        List<ProductionTypeItemEntity> list =service.queryList(param);
        List<ProductionTypeItemVO> mapList =BeanMapper.mapList(list, ProductionTypeItemVO.class);
        return CommonResponse.success(mapList);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProductionTypeItemEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProductionTypeItem-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProductionTypeItemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProductionTypeItemVO>> refProductionTypeItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProductionTypeItemEntity> page = service.queryPage(param,false);
        IPage<ProductionTypeItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionTypeItemVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
