package com.ejianc.business.sddjsorg.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.Date;
import java.util.List;

/**
 * 股东决策
 *
 * @author CJ
 * @Description: 股东决策
 * @date 2021/10/20 9:33
 */
@TableName(value = "ejc_sddjsorg_shareholder_decision")
public class ShareholderDecisionEntity extends BaseEntity {
    private static final long serialVersionUID = -962960582854820052L;

    /**
     * 单据录入人组织Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 单据录入人组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 公司编码
     */
    @TableField(value = "sddjs_org_code")
    private String sddjsOrgCode;

    /**
     * 公司名称
     */
    @TableField(value = "sddjs_org_name")
    private String sddjsOrgName;

    /**
     * 公司id
     */
    @TableField(value = "sddjs_org_id")
    private Long sddjsOrgId;

    /**
     * 公司注册性质id
     */
    @TableField(value="org_nature_id")
    private Long orgNatureId;

    /**
     * 公司注册性质
     */
    @TableField(value="org_nature_name")
    private String orgNatureName;

    /**
     * 决策内容
     */
    @TableField(value = "decision_content")
    private Long decisionContent;
    /**
     * 决策内容名称
     */
    @TableField(value = "decision_content_name")
    private String decisionContentName;

    /**
     * 承办人Id
     */
    @TableField(value = "undertake_employee_id")
    private Long undertakeEmployeeId;

    /**
     * 承办人名称
     */
    @TableField(value = "undertake_employee_name")
    private String undertakeEmployeeName;

    /**
     * 承办部门id
     */
    @TableField(value = "undertake_dept_id")
    private Long undertakeDeptId;

    /**
     * 承办部门名称
     */
    @TableField(value = "undertake_dept_name")
    private String undertakeDeptName;

    /**
     * 主要事项描述
     */
    @TableField(value = "main_matters_desc")
    private String mainMattersDesc;

    /**
     * 需公司决策事宜
     */
    @TableField(value = "matters_decide_by_org")
    private String mattersDecideByOrg;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 档案资料
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "shareholderDecisionFileService", pidName = "pid")
    List<ShareholderDecisionFileEntity> docFiles;


    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 提交日期
     */
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @TableField(value = "effective_date")
    private Date effectiveDate;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 单据编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    @TableField(value = "enclosure")
    private String enclosure;

    @TableField(value="control_status")
    private Long controlStatus; // 控制状态id
    @TableField(value="control_status_name")
    private String controlStatusName; // 控制状态

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getSddjsOrgId() {
        return sddjsOrgId;
    }

    public void setSddjsOrgId(Long sddjsOrgId) {
        this.sddjsOrgId = sddjsOrgId;
    }

    public String getSddjsOrgCode() {
        return sddjsOrgCode;
    }

    public void setSddjsOrgCode(String sddjsOrgCode) {
        this.sddjsOrgCode = sddjsOrgCode;
    }

    public String getSddjsOrgName() {
        return sddjsOrgName;
    }

    public void setSddjsOrgName(String sddjsOrgName) {
        this.sddjsOrgName = sddjsOrgName;
    }

    public Long getOrgNatureId() {
        return orgNatureId;
    }

    public void setOrgNatureId(Long orgNatureId) {
        this.orgNatureId = orgNatureId;
    }

    public String getOrgNatureName() {
        return orgNatureName;
    }

    public void setOrgNatureName(String orgNatureName) {
        this.orgNatureName = orgNatureName;
    }

    public Long getDecisionContent() {
        return decisionContent;
    }

    public void setDecisionContent(Long decisionContent) {
        this.decisionContent = decisionContent;
    }

    public Long getUndertakeEmployeeId() {
        return undertakeEmployeeId;
    }

    public void setUndertakeEmployeeId(Long undertakeEmployeeId) {
        this.undertakeEmployeeId = undertakeEmployeeId;
    }

    public String getUndertakeEmployeeName() {
        return undertakeEmployeeName;
    }

    public void setUndertakeEmployeeName(String undertakeEmployeeName) {
        this.undertakeEmployeeName = undertakeEmployeeName;
    }

    public Long getUndertakeDeptId() {
        return undertakeDeptId;
    }

    public void setUndertakeDeptId(Long undertakeDeptId) {
        this.undertakeDeptId = undertakeDeptId;
    }

    public String getUndertakeDeptName() {
        return undertakeDeptName;
    }

    public void setUndertakeDeptName(String undertakeDeptName) {
        this.undertakeDeptName = undertakeDeptName;
    }

    public String getMainMattersDesc() {
        return mainMattersDesc;
    }

    public void setMainMattersDesc(String mainMattersDesc) {
        this.mainMattersDesc = mainMattersDesc;
    }

    public String getMattersDecideByOrg() {
        return mattersDecideByOrg;
    }

    public void setMattersDecideByOrg(String mattersDecideByOrg) {
        this.mattersDecideByOrg = mattersDecideByOrg;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<ShareholderDecisionFileEntity> getDocFiles() {
        return docFiles;
    }

    public void setDocFiles(List<ShareholderDecisionFileEntity> docFiles) {
        this.docFiles = docFiles;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getEnclosure() {
        return enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getDecisionContentName() {
        return decisionContentName;
    }

    public void setDecisionContentName(String decisionContentName) {
        this.decisionContentName = decisionContentName;
    }

    public Long getControlStatus() {
        return controlStatus;
    }

    public void setControlStatus(Long controlStatus) {
        this.controlStatus = controlStatus;
    }

    public String getControlStatusName() {
        return controlStatusName;
    }

    public void setControlStatusName(String controlStatusName) {
        this.controlStatusName = controlStatusName;
    }
}
