/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectapply.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectApply/"})
public class ProjectApplyController {
    private final String BILL_CODE_RULE = "PRJ-APPLY-01";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApplyService projectApplyService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    private final String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(from|concat|updatexml|select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)";

    private boolean isValidKey(String key) {
        return !Pattern.compile("(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(from|concat|updatexml|select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)", 2).matcher(key).find();
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<ProjectApplyVO>> pageList(@RequestBody QueryParam queryParam) {
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", this.queryPage(queryParam));
    }

    private IPage<ProjectApplyVO> queryPage(QueryParam queryParam) {
        Parameter range = (Parameter)queryParam.getParams().get("range");
        queryParam.getParams().remove("range");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if ("selfAndBelow".equals(range.getValue())) {
            CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds.add(InvocationInfoProxy.getOrgId());
        }
        long count = 0L;
        Page page = new Page();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            String projectSplit;
            Map params = queryParam.getParams();
            String billState = null != params.get("billState") ? ((Parameter)params.get("billState")).getValue().toString() : null;
            String createTime = null != params.get("createTime") ? ((Parameter)params.get("createTime")).getValue().toString() : null;
            String string = projectSplit = null != params.get("projectSplit") ? ((Parameter)params.get("projectSplit")).getValue().toString() : null;
            if (StringUtils.isNotBlank((CharSequence)createTime)) {
                Object[] rangeArr = createTime.split(",");
                rangeArr[0] = rangeArr[0] + " 00:00:00";
                rangeArr[1] = rangeArr[1] + " 23:59:59";
                createTime = StringUtils.join((Object[])rangeArr, (String)",");
            }
            if ((count = this.projectApplyService.countPage(queryParam.getSearchText(), billState, createTime, projectSplit, orgIds, null)) > 0L) {
                long pageNum;
                long pageSize = queryParam.getPageSize();
                pageSize = pageSize <= 0L ? 10L : pageSize;
                long totalPage = count / pageSize + (long)(count % pageSize == 0L ? 0 : 1);
                if (totalPage < (pageNum = (long)queryParam.getPageIndex())) {
                    pageNum = totalPage;
                }
                LinkedHashMap orderMap = queryParam.getOrderMap();
                String orderBy = null;
                if (null != orderMap && !orderMap.isEmpty()) {
                    StringBuilder sp = new StringBuilder(" ");
                    for (String key : orderMap.keySet()) {
                        if (!this.isValidKey(key) || !this.isValidKey((String)orderMap.get(key))) continue;
                        sp.append(key.replaceAll("[A-Z]", "_$0").toLowerCase()).append(" ").append((String)orderMap.get(key));
                    }
                    orderBy = sp.toString();
                }
                long startLine = (pageNum - 1L < 0L ? 0L : pageNum - 1L) * pageSize;
                List<ProjectApplyVO> records = this.projectApplyService.pageList(queryParam.getSearchText(), billState, createTime, projectSplit, orgIds, startLine, pageSize, orderBy, null);
                page.setRecords(records);
                page.setCurrent(pageNum);
            }
        } else {
            page.setCurrent(1L);
        }
        page.setTotal(count);
        page.setSize((long)queryParam.getPageSize());
        return page;
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<ProjectApplyVO> saveOrUpdate(@RequestBody ProjectApplyVO vo) {
        StringBuilder executiveAgentNames;
        ProjectApplyVO resp = null;
        ProjectApplyEntity saveEntity = null;
        HashSet repeatCheck = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)vo.getExecutiveAgentList())) {
            executiveAgentNames = new StringBuilder();
            Object repeatCheckStr = null;
            for (ExecutiveAgentVO e : vo.getExecutiveAgentList()) {
                if ("del".equals(e.getRowState())) continue;
                executiveAgentNames.append(e.getExecutiveAgentName()).append(",");
                e.setProjectSplit(vo.getProjectSplit());
            }
        } else {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u884c\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        vo.setExecutiveAgentNames(executiveAgentNames.substring(0, executiveAgentNames.length() - 1));
        if (StringUtils.isBlank((CharSequence)vo.getExecutiveAgentNames())) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u884c\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ProjectApplyVO checkVo = new ProjectApplyVO();
        checkVo.setId(vo.getId());
        checkVo.setCnName(vo.getCnName());
        List<ProjectApplyEntity> list = this.projectApplyService.getDuplicateList(checkVo);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u9879\u76ee\u4e2d\u6587\u540d\u79f0\u5df2\u88ab\u4f7f\u7528.");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getEnName())) {
            checkVo.setCnName(null);
            checkVo.setEnName(vo.getEnName());
            list = this.projectApplyService.getDuplicateList(checkVo);
            if (CollectionUtils.isNotEmpty(list)) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25, \u9879\u76ee\u82f1\u6587\u540d\u79f0\u5df2\u88ab\u4f7f\u7528.");
            }
        }
        saveEntity = (ProjectApplyEntity)((Object)BeanMapper.map((Object)vo, ProjectApplyEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        if (null == vo.getId()) {
            CommonResponse billCodeResp = this.billCodeApi.getCodeBatchByRuleCode("PRJ-APPLY-01", InvocationInfoProxy.getTenantid());
            if (!billCodeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25\uff01");
            }
            saveEntity.setBillCode((String)billCodeResp.getData());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            ProjectApplyEntity dbEntity = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(vo.getId()));
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setBillCode(dbEntity.getBillCode());
            saveEntity.setBillState(dbEntity.getBillState());
        }
        this.projectApplyService.saveOrUpdate((Object)saveEntity, false);
        resp = (ProjectApplyVO)BeanMapper.map((Object)((Object)saveEntity), ProjectApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    private String getRepeatCheckStr(String splitType, Long executiveAgentId) {
        if (StringUtils.isBlank((CharSequence)splitType)) {
            return executiveAgentId.toString();
        }
        if (splitType.indexOf(",") < 0) {
            return splitType + executiveAgentId;
        }
        Object[] typeArr = splitType.split(",");
        Arrays.sort(typeArr, String.CASE_INSENSITIVE_ORDER);
        return StringUtils.join((Object[])typeArr, (String)",") + executiveAgentId;
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ProjectApplyVO> queryDetail(@RequestParam(value="id") Long id) {
        ProjectApplyVO resp = null;
        ProjectApplyEntity dbEntity = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(id));
        if (null != dbEntity) {
            resp = (ProjectApplyVO)BeanMapper.map((Object)((Object)dbEntity), ProjectApplyVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<ProjectApplyVO> vos) {
        for (ProjectApplyVO vo2 : vos) {
            if (!BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(vo2.getBillState()) && !BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(vo2.getBillState())) continue;
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u4e0d\u80fd\u5220\u9664\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff01");
        }
        vos.forEach(vo -> this.projectApplyService.removeById(vo.getId(), false));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List voList = null;
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ProjectApplyVO> page = this.queryPage(queryParam);
        voList = page.getRecords();
        voList.forEach(vo -> {
            vo.setCreateTimeStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)vo.getCreateTime()));
            vo.setSplitTypeDisplay(vo.getProjectSplit() != false ? "\u62c6\u5206" : "\u975e\u62c6\u5206");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("sddjsProject-export.xlsx", beans, response);
    }
}

