/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectapply.controller;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.service.IExecutiveAgentService;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectInfo/"})
public class ProjectInfoController {
    @Autowired
    private IProjectApplyService projectApplyService;
    @Autowired
    private IExecutiveAgentService executiveAgentService;
    @Autowired
    private IOrgApi orgApi;
    private final String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(from|concat|updatexml|select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)";

    private boolean isValidKey(String key) {
        return !Pattern.compile("(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(from|concat|updatexml|select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)", 2).matcher(key).find();
    }

    @PostMapping(value={"queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        Parameter range = (Parameter)queryParam.getParams().get("range");
        queryParam.getParams().remove("range");
        Parameter orgIdParam = (Parameter)queryParam.getParams().get("orgId");
        queryParam.getParams().remove("orgId");
        List<Long> orgIds = new ArrayList<Long>();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = orgIdParam != null && orgIdParam.getValue() != null ? Long.parseLong(orgIdParam.getValue().toString()) : InvocationInfoProxy.getOrgId();
        if ("selfAndBelow".equals(range.getValue())) {
            CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds.add(orgId);
        }
        queryParam.getParams().put("orgIds", new Parameter("in", orgIds));
        Map params = queryParam.getParams();
        HashedMap newP = new HashedMap();
        Parameter parameter = null;
        if (null != params && !params.isEmpty()) {
            for (String key : params.keySet()) {
                parameter = (Parameter)params.get(key);
                if (!this.isValidKey(key) || !this.isValidKey(parameter.getType())) continue;
                if ("createTime".equals(key)) {
                    Object[] rangeArr = parameter.getValue().toString().split(",");
                    rangeArr[0] = rangeArr[0] + " 00:00:00";
                    rangeArr[1] = rangeArr[1] + " 23:59:59";
                    parameter.setValue((Object)StringUtils.join((Object[])rangeArr, (String)","));
                }
                newP.put(key.replaceAll("[A-Z]", "_$0").toLowerCase(), parameter);
            }
        }
        newP.put("bill_state", new Parameter("in", (Object)StringUtils.joinWith((String)",", (Object[])new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        long count = this.projectApplyService.dynamicCountPage(queryParam.getSearchText(), (Map<String, Parameter>)newP);
        Page page = new Page();
        if (count > 0L) {
            long pageSize = queryParam.getPageSize();
            long pageNum = queryParam.getPageIndex();
            long startLine = (pageNum - 1L < 0L ? 0L : pageNum - 1L) * pageSize;
            LinkedHashMap orderMap = queryParam.getOrderMap();
            String orderBy = null;
            if (null != orderMap && !orderMap.isEmpty()) {
                StringBuilder sp = new StringBuilder(" ");
                for (String key : orderMap.keySet()) {
                    if (!this.isValidKey(key) || !this.isValidKey((String)orderMap.get(key))) continue;
                    sp.append("  a.").append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" ").append((String)orderMap.get(key));
                }
                orderBy = sp.toString();
            }
            List<ProjectApplyVO> records = this.projectApplyService.dynamicPageList(queryParam.getSearchText(), (Map<String, Parameter>)newP, startLine, pageSize, orderBy);
            Map<String, Integer> numMap = this.projectApplyService.queryTotalNumber(queryParam.getSearchText(), (Map<String, Parameter>)newP);
            resp.put("total", (Object)count);
            resp.put("current", (Object)pageNum);
            resp.put("size", (Object)pageSize);
            resp.put("pages", (Object)page.getPages());
            resp.put("records", records);
            resp.put("projectTotal", (Object)numMap.get("projectTotal"));
            resp.put("notStarted", (Object)numMap.get("notStarted"));
            resp.put("beUnder", (Object)numMap.get("beUnder"));
            resp.put("stopWork", (Object)numMap.get("stopWork"));
            resp.put("alreadyComplete", (Object)numMap.get("alreadyComplete"));
            resp.put("split", (Object)numMap.get("split"));
            resp.put("notSplit", (Object)numMap.get("notSplit"));
        }
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    public CommonResponse<IPage<ProjectApplyVO>> queryLists(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        Parameter range = (Parameter)queryParam.getParams().get("range");
        queryParam.getParams().remove("range");
        Parameter orgIdParam = (Parameter)queryParam.getParams().get("orgId");
        queryParam.getParams().remove("orgId");
        List<Long> orgIds = new ArrayList<Long>();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = orgIdParam != null && orgIdParam.getValue() != null ? Long.parseLong(orgIdParam.getValue().toString()) : InvocationInfoProxy.getOrgId();
        if ("selfAndBelow".equals(range.getValue())) {
            CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds.add(orgId);
        }
        queryParam.getParams().put("orgIds", new Parameter("in", orgIds));
        Map params = queryParam.getParams();
        HashedMap newP = new HashedMap();
        Parameter parameter = null;
        if (null != params && !params.isEmpty()) {
            for (String key : params.keySet()) {
                parameter = (Parameter)params.get(key);
                if (!this.isValidKey(key) || !this.isValidKey(parameter.getType())) continue;
                if ("createTime".equals(key)) {
                    Object[] rangeArr = parameter.getValue().toString().split(",");
                    rangeArr[0] = rangeArr[0] + " 00:00:00";
                    rangeArr[1] = rangeArr[1] + " 23:59:59";
                    parameter.setValue((Object)StringUtils.join((Object[])rangeArr, (String)","));
                }
                newP.put(key.replaceAll("[A-Z]", "_$0").toLowerCase(), parameter);
            }
        }
        newP.put("bill_state", new Parameter("in", (Object)StringUtils.joinWith((String)",", (Object[])new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        long count = this.projectApplyService.dynamicCountPage(queryParam.getSearchText(), (Map<String, Parameter>)newP);
        Page page = new Page();
        if (count > 0L) {
            long pageSize = queryParam.getPageSize();
            long pageNum = queryParam.getPageIndex();
            long startLine = (pageNum - 1L < 0L ? 0L : pageNum - 1L) * pageSize;
            LinkedHashMap orderMap = queryParam.getOrderMap();
            String orderBy = null;
            if (null != orderMap && !orderMap.isEmpty()) {
                StringBuilder sp = new StringBuilder(" ");
                for (String key : orderMap.keySet()) {
                    if (!this.isValidKey(key) || !this.isValidKey((String)orderMap.get(key))) continue;
                    sp.append("  a.").append(CamelAndUnderLineConverter.humpToLine((String)key)).append(" ").append((String)orderMap.get(key));
                }
                orderBy = sp.toString();
            }
            List<ProjectApplyVO> records = this.projectApplyService.dynamicPageList(queryParam.getSearchText(), (Map<String, Parameter>)newP, startLine, pageSize, orderBy);
            Map<String, Integer> numMap = this.projectApplyService.queryTotalNumber(queryParam.getSearchText(), (Map<String, Parameter>)newP);
            page.setCurrent(pageNum);
            page.setSize(pageSize);
            page.setTotal(count);
            page.setRecords(records);
        }
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"queryExecutiveAgentList"})
    public CommonResponse<List<ExecutiveAgentVO>> queryExecutiveAgentList(@RequestParam(value="projectId") Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_apply_id", (Object)projectId);
        List list = this.executiveAgentService.list((Wrapper)queryWrapper);
        List backList = new ArrayList();
        if (list != null && list.size() > 0) {
            backList = BeanMapper.mapList((Iterable)list, ExecutiveAgentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", backList);
    }

    @PostMapping(value={"changeStatus"})
    public CommonResponse<String> changeStatus(@RequestBody List<ProjectApplyVO> dataList) {
        ArrayList<Object> orgVOs = new ArrayList<Object>();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (dataList != null && dataList.size() > 0) {
            for (ProjectApplyVO vo : dataList) {
                projectIds.add(vo.getId());
            }
        } else {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = (List)this.projectApplyService.listByIds(projectIds);
        if (list == null || list.size() <= 0) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer status = dataList.get(0).getStatus();
        for (ProjectApplyEntity projectApplyEntity : list) {
            projectApplyEntity.setStatus(status);
            CommonResponse data = this.orgApi.detailById(projectApplyEntity.getProjectDepartmentId());
            if (data.isSuccess() && data.getData() != null) {
                orgVOs.add(data.getData());
                continue;
            }
            throw new BusinessException("\u67e5\u8be2[" + projectApplyEntity.getCnName() + "]\u5bf9\u5e94\u7684\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25");
        }
        this.projectApplyService.saveOrUpdateBatch(list, list.size(), false);
        for (OrgVO orgVO : orgVOs) {
            if (status.equals(ProjectApplyVO.PROJECT_STATUS_NO_START) || status.equals(ProjectApplyVO.PROJECT_STATUS_UNDERCONSTRUCTION)) {
                orgVO.setState(Integer.valueOf(1));
                continue;
            }
            orgVO.setState(Integer.valueOf(0));
        }
        this.orgApi.saveProOrgList(orgVOs);
        return CommonResponse.success((String)"\u6539\u53d8\u72b6\u6001\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List voList = null;
        HashMap<Integer, String> statusMap = new HashMap<Integer, String>();
        statusMap.put(0, "\u672a\u5f00\u5de5");
        statusMap.put(1, "\u5728\u5efa");
        statusMap.put(2, "\u505c\u7528");
        statusMap.put(3, "\u5df2\u5b8c\u5de5");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(0);
        IPage page = (IPage)this.queryLists(queryParam).getData();
        voList = page.getRecords();
        voList.forEach(vo -> {
            vo.setSplitTypeDisplay(vo.getProjectSplit() != false ? "\u62c6\u5206" : "\u975e\u62c6\u5206");
            vo.setStatusDisplay((String)statusMap.get(vo.getStatus()));
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("sddjsProjectInfo-export.xlsx", beans, response);
    }
}

