/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectapply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.projectapply.bean.ExecutiveAgentEntity;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.bean.ProjectChangeEntity;
import com.ejianc.business.projectapply.mapper.ProjectChangeMapper;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.service.IProjectChangeService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.business.projectapply.vo.ProjectChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="projectChangeService")
public class ProjectChangeServiceImpl
extends BaseServiceImpl<ProjectChangeMapper, ProjectChangeEntity>
implements IProjectChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProjectChangeMapper projectChangeMapper;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${oms.splitPrjBelongOrgName}")
    private String splitPrjBelongOrgName;
    @Value(value="${oms.splitPrjBelongOrgType}")
    private Integer splitPrjBelongOrgType;
    @Autowired
    private IProjectApplyService projectApplyService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectChangeService projectChangeService;

    @Override
    public List<ProjectChangeEntity> getAllByProjectId(Long projectId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"project_id", (Object)projectId);
        return this.projectChangeMapper.selectList((Wrapper)query);
    }

    @Override
    public CommonResponse<ProjectApplyVO> saveChange(ProjectApplyVO vo) {
        String newd;
        Iterator<ExecutiveAgentEntity> newFinish;
        String newStart;
        String old;
        String oldFinish;
        Object oldStart;
        SimpleDateFormat formatter;
        ProjectApplyVO checkVo = new ProjectApplyVO();
        checkVo.setId(vo.getId());
        checkVo.setCnName(vo.getCnName());
        List<ProjectApplyEntity> checklist = this.projectApplyService.getDuplicateList(checkVo);
        if (CollectionUtils.isNotEmpty(checklist)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u9879\u76ee\u4e2d\u6587\u540d\u79f0\u5df2\u88ab\u4f7f\u7528.");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getEnName())) {
            checkVo.setCnName(null);
            checkVo.setEnName(vo.getEnName());
            checklist = this.projectApplyService.getDuplicateList(checkVo);
            if (CollectionUtils.isNotEmpty(checklist)) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25, \u9879\u76ee\u82f1\u6587\u540d\u79f0\u5df2\u88ab\u4f7f\u7528.");
            }
        }
        HashSet repeatCheck = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)vo.getExecutiveAgentList())) {
            StringBuilder executiveAgentNames = new StringBuilder();
            Object repeatCheckStr = null;
            for (ExecutiveAgentVO e : vo.getExecutiveAgentList()) {
                if ("del".equals(e.getRowState())) continue;
                executiveAgentNames.append(e.getExecutiveAgentName()).append(",");
                e.setProjectSplit(vo.getProjectSplit());
            }
            vo.setExecutiveAgentNames(executiveAgentNames.substring(0, executiveAgentNames.length() - 1));
        }
        if (StringUtils.isBlank((CharSequence)vo.getExecutiveAgentNames())) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u884c\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ProjectApplyEntity oldEntity = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(vo.getId()));
        String changeContent = "";
        boolean cnNameChange = false;
        boolean enNameChange = false;
        String oldCnName = oldEntity.getCnName();
        String oldEnName = oldEntity.getEnName();
        boolean changeOrg = false;
        if (!vo.getCnName().equals(oldEntity.getCnName())) {
            changeContent = changeContent + "[\u9879\u76ee\u540d\u79f0(\u4e2d\u6587)]\uff1a\u7531\"" + (StringUtils.isNotBlank((CharSequence)oldEntity.getCnName()) ? oldEntity.getCnName() : "") + '\"' + "\u6539\u4e3a" + '\"' + (StringUtils.isNotBlank((CharSequence)vo.getCnName()) ? vo.getCnName() : "") + '\"';
            cnNameChange = true;
            changeOrg = true;
            oldEntity.setCnName(vo.getCnName());
        }
        if (StringUtils.isBlank((CharSequence)vo.getEnName()) && StringUtils.isNotBlank((CharSequence)oldEntity.getEnName()) || StringUtils.isBlank((CharSequence)oldEntity.getEnName()) && StringUtils.isNotBlank((CharSequence)vo.getEnName()) || StringUtils.isNotBlank((CharSequence)oldEntity.getEnName()) && StringUtils.isNotBlank((CharSequence)vo.getEnName()) && !vo.getEnName().equals(oldEntity.getEnName())) {
            changeContent = changeContent.length() > 0 ? changeContent + ",[\u9879\u76ee\u540d\u79f0(\u82f1\u6587)]\uff1a\u7531\"" + (StringUtils.isNotBlank((CharSequence)oldEntity.getEnName()) ? oldEntity.getEnName() : "") + '\"' + "\u6539\u4e3a" + '\"' + (StringUtils.isNotBlank((CharSequence)vo.getEnName()) ? vo.getEnName() : "") + '\"' : changeContent + "[\u9879\u76ee\u540d\u79f0(\u82f1\u6587)]\uff1a\u7531\"" + (StringUtils.isNotBlank((CharSequence)oldEntity.getEnName()) ? oldEntity.getEnName() : "") + '\"' + "\u6539\u4e3a" + '\"' + (StringUtils.isNotBlank((CharSequence)vo.getEnName()) ? vo.getEnName() : "") + '\"';
            enNameChange = true;
            oldEntity.setEnName(vo.getEnName());
        }
        if (cnNameChange) {
            if (StringUtils.isNotBlank((CharSequence)oldEntity.getUsedNames())) {
                oldEntity.setUsedNames(oldEntity.getUsedNames() + "," + oldCnName);
            } else {
                oldEntity.setUsedNames(oldCnName);
            }
        }
        if (enNameChange && StringUtils.isNotBlank((CharSequence)oldEnName)) {
            if (StringUtils.isNotBlank((CharSequence)oldEntity.getUsedNames())) {
                oldEntity.setUsedNames(oldEntity.getUsedNames() + "," + oldEnName + "(\u82f1\u6587\u540d)");
            } else {
                oldEntity.setUsedNames(oldEnName + "(\u82f1\u6587\u540d)");
            }
        }
        if (!vo.getProjectType().equals(oldEntity.getProjectType())) {
            changeContent = changeContent.length() > 0 ? changeContent + ",[\u9879\u76ee\u7c7b\u578b]\uff1a\u7531\"" + oldEntity.getProjectTypeName() + '\"' + "\u6539\u4e3a" + '\"' + vo.getProjectTypeName() + '\"' : changeContent + "[\u9879\u76ee\u7c7b\u578b]\uff1a\u7531\"" + oldEntity.getProjectTypeName() + '\"' + "\u6539\u4e3a" + '\"' + vo.getProjectTypeName() + '\"';
            oldEntity.setProjectType(vo.getProjectType());
            oldEntity.setProjectTypeName(vo.getProjectTypeName());
        }
        if (!vo.getProjectClassification().equals(oldEntity.getProjectClassification())) {
            changeContent = changeContent.length() > 0 ? changeContent + ",[\u56fd\u5185/\u56fd\u5916\u9879\u76ee]\uff1a\u7531\"" + oldEntity.getProjectClassification() + '\"' + "\u6539\u4e3a" + '\"' + vo.getProjectClassification() + '\"' : changeContent + "[\u56fd\u5185/\u56fd\u5916\u9879\u76ee]\uff1a\u7531\"" + oldEntity.getProjectClassification() + '\"' + "\u6539\u4e3a" + '\"' + vo.getProjectClassification() + '\"';
            oldEntity.setProjectClassification(vo.getProjectClassification());
        }
        if (StringUtils.isBlank((CharSequence)vo.getRemark()) && StringUtils.isNotBlank((CharSequence)oldEntity.getRemark()) || StringUtils.isBlank((CharSequence)oldEntity.getRemark()) && StringUtils.isNotBlank((CharSequence)vo.getRemark()) || StringUtils.isNotBlank((CharSequence)oldEntity.getRemark()) && StringUtils.isNotBlank((CharSequence)vo.getRemark()) && !vo.getRemark().equals(oldEntity.getRemark())) {
            changeContent = changeContent.length() > 0 ? changeContent + ",[\u5907\u6ce8]\uff1a\u7531\"" + (StringUtils.isNotBlank((CharSequence)oldEntity.getRemark()) ? oldEntity.getRemark() : "") + '\"' + "\u6539\u4e3a" + '\"' + (StringUtils.isNotBlank((CharSequence)vo.getRemark()) ? vo.getRemark() : "") + '\"' : changeContent + "[\u5907\u6ce8]\uff1a\u7531\"" + (StringUtils.isNotBlank((CharSequence)oldEntity.getRemark()) ? oldEntity.getRemark() : "") + '\"' + "\u6539\u4e3a" + '\"' + (StringUtils.isNotBlank((CharSequence)vo.getRemark()) ? vo.getRemark() : "") + '\"';
            oldEntity.setRemark(vo.getRemark());
        }
        if (!vo.getProjectStartDate().equals(oldEntity.getProjectStartDate())) {
            formatter = new SimpleDateFormat("yyyy-MM-dd");
            oldStart = formatter.format(oldEntity.getProjectStartDate());
            oldFinish = formatter.format(oldEntity.getProjectFinishDate());
            old = (String)oldStart + " - " + oldFinish;
            newStart = formatter.format(vo.getProjectStartDate());
            newFinish = formatter.format(vo.getProjectFinishDate());
            newd = newStart + " - " + (String)((Object)newFinish);
            changeContent = changeContent.length() > 0 ? changeContent + ",[\u8ba1\u5212\u5f00\u5de5/\u7ae3\u5de5\u65e5\u671f]\uff1a\u7531\"" + old + '\"' + "\u6539\u4e3a" + '\"' + newd + '\"' : changeContent + "[\u8ba1\u5212\u5f00\u5de5/\u7ae3\u5de5\u65e5\u671f]\uff1a\u7531\"" + old + '\"' + "\u6539\u4e3a" + '\"' + newd + '\"';
            oldEntity.setProjectStartDate(vo.getProjectStartDate());
        } else if (!vo.getProjectFinishDate().equals(oldEntity.getProjectFinishDate())) {
            formatter = new SimpleDateFormat("yyyy-MM-dd");
            oldStart = formatter.format(oldEntity.getProjectStartDate());
            oldFinish = formatter.format(oldEntity.getProjectFinishDate());
            old = (String)oldStart + " - " + oldFinish;
            newStart = formatter.format(vo.getProjectStartDate());
            newFinish = formatter.format(vo.getProjectFinishDate());
            newd = newStart + " - " + newFinish;
            changeContent = changeContent.length() > 0 ? changeContent + ",[\u8ba1\u5212\u5f00\u5de5/\u7ae3\u5de5\u65e5\u671f]\uff1a\u7531\"" + old + '\"' + "\u6539\u4e3a" + '\"' + newd + '\"' : changeContent + "[\u8ba1\u5212\u5f00\u5de5/\u7ae3\u5de5\u65e5\u671f]\uff1a\u7531\"" + old + '\"' + "\u6539\u4e3a" + '\"' + newd + '\"';
            oldEntity.setProjectFinishDate(vo.getProjectFinishDate());
        }
        if (!vo.getProjectSplit().equals(oldEntity.getProjectSplit())) {
            changeOrg = true;
            this.dealOrg(vo, oldEntity);
        } else if (!vo.getProjectSplit().booleanValue()) {
            Long newOrgId = null;
            for (ExecutiveAgentVO e : vo.getExecutiveAgentList()) {
                if ("del".equals(e.getRowState())) continue;
                newOrgId = e.getExecutiveAgentId();
                break;
            }
            if (!oldEntity.getExecutiveAgentList().get(0).getExecutiveAgentId().equals(newOrgId)) {
                changeOrg = true;
                this.dealOrg(vo, oldEntity);
            }
        }
        oldEntity.setProjectSplit(vo.getProjectSplit());
        List executiveAgentList = vo.getExecutiveAgentList();
        if (executiveAgentList != null && executiveAgentList.size() > 0) {
            String content = "";
            String oldContent = "";
            boolean change = false;
            HashMap<Long, ExecutiveAgentEntity> oldExecutiveMap = new HashMap<Long, ExecutiveAgentEntity>();
            if (oldEntity.getExecutiveAgentList() != null && oldEntity.getExecutiveAgentList().size() > 0) {
                for (ExecutiveAgentEntity executiveAgentEntity : oldEntity.getExecutiveAgentList()) {
                    oldExecutiveMap.put(executiveAgentEntity.getId(), executiveAgentEntity);
                    if (oldContent.length() > 0) {
                        oldContent = oldContent + "," + (StringUtils.isNotBlank((CharSequence)executiveAgentEntity.getSplitType()) ? executiveAgentEntity.getSplitType() + "-" : "") + executiveAgentEntity.getExecutiveAgentName();
                        continue;
                    }
                    oldContent = oldContent + (StringUtils.isNotBlank((CharSequence)executiveAgentEntity.getSplitType()) ? executiveAgentEntity.getSplitType() + "-" : "") + executiveAgentEntity.getExecutiveAgentName();
                }
            }
            for (ExecutiveAgentVO executiveAgentVO : executiveAgentList) {
                if ("add".equals(executiveAgentVO.getRowState())) {
                    change = true;
                    if (content.length() > 0) {
                        content = content + "," + (StringUtils.isNotBlank((CharSequence)executiveAgentVO.getSplitType()) ? executiveAgentVO.getSplitType() + "-" : "") + executiveAgentVO.getExecutiveAgentName();
                        continue;
                    }
                    content = content + (StringUtils.isNotBlank((CharSequence)executiveAgentVO.getSplitType()) ? executiveAgentVO.getSplitType() + "-" : "") + executiveAgentVO.getExecutiveAgentName();
                    continue;
                }
                if ("del".equals(executiveAgentVO.getRowState())) {
                    change = true;
                    continue;
                }
                if ("edit".equals(executiveAgentVO.getRowState())) {
                    ExecutiveAgentEntity entity = (ExecutiveAgentEntity)((Object)oldExecutiveMap.get(executiveAgentVO.getId()));
                    if (!entity.getSplitType().equals(executiveAgentVO.getSplitType())) {
                        change = true;
                    }
                    if (!entity.getExecutiveAgentId().equals(executiveAgentVO.getExecutiveAgentId())) {
                        change = true;
                    }
                    if (!entity.getRemark().equals(executiveAgentVO.getRemark())) {
                        change = true;
                    }
                    if (content.length() > 0) {
                        content = content + "," + (StringUtils.isNotBlank((CharSequence)executiveAgentVO.getSplitType()) ? executiveAgentVO.getSplitType() + "-" : "") + executiveAgentVO.getExecutiveAgentName();
                        continue;
                    }
                    content = content + (StringUtils.isNotBlank((CharSequence)executiveAgentVO.getSplitType()) ? executiveAgentVO.getSplitType() + "-" : "") + executiveAgentVO.getExecutiveAgentName();
                    continue;
                }
                if (content.length() > 0) {
                    content = content + "," + (StringUtils.isNotBlank((CharSequence)executiveAgentVO.getSplitType()) ? executiveAgentVO.getSplitType() + "-" : "") + executiveAgentVO.getExecutiveAgentName();
                    continue;
                }
                content = content + (StringUtils.isNotBlank((CharSequence)executiveAgentVO.getSplitType()) ? executiveAgentVO.getSplitType() + "-" : "") + executiveAgentVO.getExecutiveAgentName();
            }
            if (change) {
                changeContent = changeContent.length() > 0 ? changeContent + ",[\u6267\u884c\u4e3b\u4f53]\uff1a\u7531\"" + oldContent + '\"' + "\u6539\u4e3a" + '\"' + content + '\"' : changeContent + "[\u6267\u884c\u4e3b\u4f53]\uff1a\u7531\"" + oldContent + '\"' + "\u6539\u4e3a" + '\"' + content + '\"';
            }
            List list = BeanMapper.mapList((Iterable)executiveAgentList, ExecutiveAgentEntity.class);
            oldEntity.setExecutiveAgentList(list);
            oldEntity.setExecutiveAgentNames(vo.getExecutiveAgentNames());
        }
        if (changeOrg) {
            CommonResponse oldOrgData = this.orgApi.detailById(oldEntity.getProjectDepartmentId());
            if (oldOrgData.isSuccess() && oldOrgData.getData() != null) {
                OrgVO orgVO = (OrgVO)oldOrgData.getData();
                orgVO.setName(oldEntity.getCnName());
                orgVO.setParentId(oldEntity.getOrgId());
                this.orgApi.saveOrgInfo(orgVO);
            } else {
                this.logger.info("\u540c\u6b65\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u9879\u76ee\u90e8\u4fe1\u606f---->" + oldOrgData.getMsg());
                throw new BusinessException("\u540c\u6b65\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u9879\u76ee\u90e8\u4fe1\u606f");
            }
        }
        this.projectApplyService.saveOrUpdate((Object)oldEntity, false);
        if (StringUtils.isNotBlank((CharSequence)changeContent)) {
            ProjectChangeEntity projectChange = new ProjectChangeEntity();
            projectChange.setChangeUserName(this.sessionManager.getUserContext().getUserName());
            projectChange.setChangeContent(changeContent);
            projectChange.setProjectId(oldEntity.getId());
            this.saveOrUpdate((Object)projectChange, false);
        }
        ProjectApplyVO back = (ProjectApplyVO)BeanMapper.map((Object)((Object)oldEntity), ProjectApplyVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)oldEntity.getId());
        queryWrapper.orderByDesc((Object)"create_time");
        List list = this.projectChangeService.list((Wrapper)queryWrapper);
        List backList = new ArrayList();
        if (list != null && list.size() > 0) {
            backList = BeanMapper.mapList((Iterable)list, ProjectChangeVO.class);
        }
        back.setProjectChangeList(backList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)back);
    }

    private String getRepeatCheckStr(String splitType, Long executiveAgentId) {
        if (StringUtils.isBlank((CharSequence)splitType)) {
            return executiveAgentId.toString();
        }
        if (splitType.indexOf(",") < 0) {
            return splitType + executiveAgentId;
        }
        Object[] typeArr = splitType.split(",");
        Arrays.sort(typeArr, String.CASE_INSENSITIVE_ORDER);
        return StringUtils.join((Object[])typeArr, (String)",") + executiveAgentId;
    }

    private void dealOrg(ProjectApplyVO vo, ProjectApplyEntity oldEntity) {
        OrgVO parent = null;
        if (vo.getProjectSplit().booleanValue()) {
            OrgVO query = new OrgVO();
            query.setName(this.splitPrjBelongOrgName);
            query.setTenantId(InvocationInfoProxy.getTenantid());
            query.setOrgType(this.splitPrjBelongOrgType);
            CommonResponse parentOrgInfoResp = this.orgApi.findOneByOrgVO(query);
            if (!parentOrgInfoResp.isSuccess()) {
                throw new BusinessException("\u62c6\u5206\u9879\u76ee\u67e5\u8be2\u6307\u5b9a\u4e0a\u7ea7: \u540d\u79f0-" + this.splitPrjBelongOrgName + "\uff0c\u7c7b\u578b-" + this.splitPrjBelongOrgType + "\u7684\u7ec4\u7ec7\u5931\u8d25\uff01");
            }
            parent = (OrgVO)parentOrgInfoResp.getData();
        } else {
            ExecutiveAgentVO sub = new ExecutiveAgentVO();
            CommonResponse parentOrgInfoResp = vo.getExecutiveAgentList().iterator();
            while (parentOrgInfoResp.hasNext()) {
                ExecutiveAgentVO e = (ExecutiveAgentVO)parentOrgInfoResp.next();
                if ("del".equals(e.getRowState())) continue;
                sub = e;
                break;
            }
            if (!(parentOrgInfoResp = this.orgApi.detailById(sub.getExecutiveAgentId())).isSuccess()) {
                throw new BusinessException("\u975e\u62c6\u5206\u9879\u76ee\u67e5\u8be2\u6307\u5b9a\u4e0a\u7ea7: \u540d\u79f0-" + sub.getExecutiveAgentName() + "\u7684\u7ec4\u7ec7\u5931\u8d25\uff01");
            }
            parent = (OrgVO)parentOrgInfoResp.getData();
        }
        if (null == parent) {
            throw new BusinessException("\u9879\u76ee\u4e0a\u7ea7\u7ec4\u7ec7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        oldEntity.setOrgName(parent.getName());
        oldEntity.setOrgId(parent.getId());
    }
}

