/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectapply.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.service.IExecutiveAgentService;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectInfo/"})
public class ProjectInfoController {
    @Autowired
    private IProjectApplyService projectApplyService;
    @Autowired
    private IExecutiveAgentService executiveAgentService;
    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value={"queryList"})
    public CommonResponse<IPage<ProjectApplyVO>> queryList(@RequestBody QueryParam queryParam) {
        String projectSplit;
        Parameter range = (Parameter)queryParam.getParams().get("range");
        queryParam.getParams().remove("range");
        Parameter orgIdParam = (Parameter)queryParam.getParams().get("orgId");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        Long orgId = orgIdParam != null && orgIdParam.getValue() != null ? Long.parseLong(orgIdParam.getValue().toString()) : InvocationInfoProxy.getOrgId();
        if ("selfAndBelow".equals(range.getValue())) {
            CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds.add(orgId);
        }
        Map params = queryParam.getParams();
        String billState = "1,3";
        String createTime = null != params.get("createTime") ? ((Parameter)params.get("createTime")).getValue().toString() : null;
        String string = projectSplit = null != params.get("projectSplit") ? ((Parameter)params.get("projectSplit")).getValue().toString() : null;
        if (StringUtils.isNotBlank((CharSequence)createTime)) {
            Object[] rangeArr = createTime.split(",");
            rangeArr[0] = rangeArr[0] + " 00:00:00";
            rangeArr[1] = rangeArr[1] + " 23:59:59";
            createTime = StringUtils.join((Object[])rangeArr, (String)",");
        }
        String status = null != params.get("status") ? ((Parameter)params.get("status")).getValue().toString() : null;
        long count = this.projectApplyService.countPage(queryParam.getSearchText(), billState, createTime, projectSplit, orgIds, status);
        Page page = new Page();
        if (count > 0L) {
            long pageSize = queryParam.getPageSize();
            long pageNum = queryParam.getPageIndex();
            pageNum = pageNum - 1L < 0L ? 0L : pageNum - 1L;
            long startLine = pageNum * pageSize;
            List<ProjectApplyVO> records = this.projectApplyService.pageList(queryParam.getSearchText(), billState, createTime, projectSplit, orgIds, startLine, pageSize, (String)queryParam.getOrderMap().get("createTime"), status);
            page.setCurrent(pageNum);
            page.setSize(pageSize);
            page.setTotal(count);
            page.setRecords(records);
        }
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"queryExecutiveAgentList"})
    public CommonResponse<List<ExecutiveAgentVO>> queryExecutiveAgentList(@RequestParam(value="projectId") Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_apply_id", (Object)projectId);
        List list = this.executiveAgentService.list((Wrapper)queryWrapper);
        List backList = new ArrayList();
        if (list != null && list.size() > 0) {
            backList = BeanMapper.mapList((Iterable)list, ExecutiveAgentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", backList);
    }

    @PostMapping(value={"changeStatus"})
    public CommonResponse<String> changeStatus(@RequestBody List<ProjectApplyVO> dataList) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (dataList != null && dataList.size() > 0) {
            for (ProjectApplyVO vo : dataList) {
                projectIds.add(vo.getId());
            }
        } else {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = (List)this.projectApplyService.listByIds(projectIds);
        if (list == null || list.size() <= 0) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean status = true;
        if (ProjectApplyVO.PROJECT_STATUS_OPEN.equals(((ProjectApplyEntity)((Object)list.get(0))).getStatus())) {
            status = false;
        }
        for (ProjectApplyEntity entity : list) {
            if (status.booleanValue()) {
                entity.setStatus(ProjectApplyVO.PROJECT_STATUS_OPEN);
                continue;
            }
            entity.setStatus(ProjectApplyVO.PROJECT_STATUS_DISCONTINUED);
        }
        this.projectApplyService.saveOrUpdateBatch(list, list.size(), false);
        return CommonResponse.success((String)((status != false ? "\u542f\u7528" : "\u505c\u7528") + "\u6210\u529f\uff01"));
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List voList = null;
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage page = (IPage)this.queryList(queryParam).getData();
        voList = page.getRecords();
        voList.forEach(vo -> {
            vo.setSplitTypeDisplay(vo.getProjectSplit() != false ? "\u62c6\u5206" : "\u975e\u62c6\u5206");
            vo.setStatusDisplay(ProjectApplyVO.PROJECT_STATUS_OPEN.equals(vo.getStatus()) ? "\u542f\u7528" : "\u505c\u7528");
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("sdsjProjectInfo-export.xlsx", beans, response);
    }
}

