package com.ejianc.business.sealm.api;

import java.util.List;

import com.ejianc.business.sealm.hyxtrix.InstoreHystrix;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.framework.core.response.CommonResponse;

/**
 * 入库单的rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-sealm-web", url="${common.env.feign-client-url}", path="ejc-sealm-web", fallback = InstoreHystrix.class)
public interface IInstoreApi {


    /**
     * @Author liyongjia
     * @Date 2020/6/10  新增用印申请
     * @Description updatePayment
     * @Param [vos]
     * @Return 
     */
	@RequestMapping(value = "/api/instore/addYysq", method=RequestMethod.POST)
	public CommonResponse<String> addYysq(@RequestBody YysqVO vo);


	/**
	 * @Author chenchunlei
	 * @Date 2021/1/26  新增印章登记
	 * @param vo
	 * @return
	 */
	@RequestMapping(value = "/api/instore/addYzdj", method=RequestMethod.POST)
	public CommonResponse<String> addYzdj(@RequestBody YzdjVO vo);
	
}
