package com.ejianc.business.sealm.utils;

import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.stream.Collectors;

/**
 * @Auther: 
 * @Date: 2018/10/19 15:49
 * @Description:
 */
public class AESUtil {
    static Logger logger = LoggerFactory.getLogger(AESUtil.class);
    // 密钥
    public static String key = "QunJe#XC%SLCC@18";
    private static String charset = "utf-8";
    // 偏移量
    private static int offset = 16;
    // 加密器类型:加密算法为AES,加密模式为CBC,补码方式为PKCS5Padding
    private static String transformation = "AES/ECB/PKCS5Padding";
    // 算法类型：用于指定生成AES的密钥
    private static String algorithm = "AES";
 
    /**
     * 加密
     *
     * @param content
     * @return
     */
    public static byte[] encrypt(String content) {
        return encrypt(content, key);
    }
 
    /**
     * 解密
     *
     * @param content
     * @return
     */
    public static String decrypt(String content) {
        return decrypt(content, key);
    }
 
    /**
     * 加密
     *
     * @param content 需要加密的内容
     * @param key     加密密码
     * @return
     */
    public static byte[] encrypt(String content, String key) {
        try {
            //构造密钥
            SecretKeySpec skey = new SecretKeySpec(key.getBytes("utf-8"), algorithm);
            //创建初始向量iv用于指定密钥偏移量(可自行指定但必须为128位)，因为AES是分组加密，下一组的iv就用上一组加密的密文来充当
            //IvParameterSpec iv = new IvParameterSpec(key.getBytes(), 0, offset);
            //创建AES加密器
            Cipher cipher = Cipher.getInstance(transformation);
            byte[] byteContent = content.getBytes(charset);
            //使用加密器的加密模式
            cipher.init(Cipher.ENCRYPT_MODE, skey);
            // 加密
            byte[] result = cipher.doFinal(byteContent);
            System.out.println(result.length);
            //使用BASE64对加密后的二进制数组进行编码
            String s = new Base64().encodeToString(result).replaceAll("\\r|\\n", "");
            byte[] bytes = s.getBytes(charset);
            //System.out.println(bytes.length);
            //String url = "https://zzyj.ca.qunje.com:8008/stampInterface/order/addYZSQAndSealOrder";
            //String http = http(url, bytes);
           // System.out.println(http);
            return bytes;
        } catch (Exception e) {
            logger.info("", e);
        }
        return null;
        //if (str == null || key == null) return null;
        //        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        //        cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(key.getBytes("utf-8"), "AES"));
        //        byte[] bytes = cipher.doFinal(str.getBytes("utf-8"));
        //        return new BASE64Encoder().encode(bytes);
    }
 
    /**
     * AES（256）解密
     *
     * @param content 待解密内容
     * @param key     解密密钥
     * @return 解密之后KEY
     * @throws Exception
     */
    public static String decrypt(String content, String key) {
        try {
 
            SecretKeySpec skey = new SecretKeySpec(key.getBytes(), algorithm);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes(), 0, offset);
            Cipher cipher = Cipher.getInstance(transformation);
            //解密时使用加密器的解密模式
            cipher.init(Cipher.DECRYPT_MODE, skey);// 初始化
            byte[] result = cipher.doFinal(new Base64().decode(content));
            return new String(result); // 解密
        } catch (Exception e) {
            logger.info("", e);
        }
        return null;
    }
 
    public static void main(String[] args) {
        String s = "{\"details\":[{\"sealCount\":5,\"sealNo\":\"20220407001\",\"sessionId\":\"1000015552022\",\"caseId\":\"11112222111\"}],\"description\":\"测试2022\",\"isTakeOut\":\"0\",\"depName\":\"郑州一建集团\",\"applicantName\":\"张继永\",\"vertifyCode\":\"275285\",\"formNo\":\"liucheng2022\",\"phoneNumber\":\"1111111\",\"sealUserName\":\"张继永\",\"fingerNo\":\"1134\",\"title\":\"ZCHTYYSQB20210908160623266\",\"caseId\":\"11112222111\",\"workflowName\":\"1111222\"}";
        byte[] encryptResultStr = encrypt(s);
        //String encryptResultStr1 = "F4ukUCSCwz+WKf7PPScs+rAqNra1Wv5lShaleL0okLPWK1mn7M90LW2wniEGXfpLnYBod5t7Q1a2vIYkyDgsuC2thCYh/QlsoXNAfgXixsEFrdmuhu2645d8YbkGDXytY/Fwps5/qFkNmbAVS4zp8z7zKgB1wHrRBvyr1QUCmiqYpUi1Shp8dy0f0sm2XXJEiMZ94yVFGjSWzgslrVXhd2aUAy+KU+gfpITO6TEzm+3bmts5UNFSuoQqylF+T1I8dXbFu0MwU+4EB2nTQfR6/j/fiqva2BX33gA1rH+5KW15icgonGWCJahfhv1u5gfDIOvSosna4zi2CDPqmkoJT2M8N5P1cFSuGDrXV6EMiYF14BYymMQNBIw1S17L/obPeh+pGcsBJij18rJZbk4ec8Zns9pB02d77PcYAMow1MnlMacTY7SEh8U/1zTF2X91aW/T7aRYc8Pxz2or2/ZN2fMOjl6MUQQqjpuJ8b2TLps32K+Sx33OauikibfelpeT4oDLuhIzedjASvkKGtJf0bnBg4M13+ttTFVRxdnPOVc=";
                // 加密
        System.out.println("加密前：" + s);
        System.out.println("加密后：" + encryptResultStr);
        // 解密
        //System.out.println("解密后1：" + decrypt(encryptResultStr1));

    }
    public static String http(String url, byte[] PostData) {
        URL u = null;
        HttpURLConnection con = null;
        InputStream inputStream = null;
        String str = null;
        //尝试发送请求
        try {
            u = new URL(url);
            con = (HttpURLConnection) u.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/json");
            OutputStream outStream = con.getOutputStream();
            outStream.write(PostData);
            outStream.flush();
            outStream.close();
            //读取返回内容
            inputStream = con.getInputStream();
            str = new BufferedReader(new InputStreamReader(inputStream))
                    .lines().collect(Collectors.joining(System.lineSeparator()));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (con != null) {
                con.disconnect();
            }
            return str;
        }
    }

}