package com.ejianc.business.sealm.controller;

import java.io.Serializable;

import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.YzsqEntity;
import com.ejianc.business.sealm.consts.SealmCommonConsts;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sealm.bean.ZzryjEntity;
import com.ejianc.business.sealm.service.IZzryjService;
import com.ejianc.business.sealm.vo.ZzryjVO;

/**
 * 责任人移交
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("zzryj")
public class ZzryjController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZRRYJ_CODE";//此处需要根据实际修改
    
    @Autowired
    private IZzryjService service;

    @Autowired
    private IYzdjService yzdjService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ZzryjVO> saveOrUpdate(@RequestBody ZzryjVO saveorUpdateVO) {
    	ZzryjEntity entity = BeanMapper.map(saveorUpdateVO, ZzryjEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
             //   entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ZzryjVO vo = BeanMapper.map(entity, ZzryjVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ZzryjVO> queryDetail(Long id) {
    	ZzryjEntity entity = service.selectById(id);
    	ZzryjVO vo = BeanMapper.map(entity, ZzryjVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ZzryjVO> vos) {
        service.removeByIds(vos.stream().map(ZzryjVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ZzryjVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ZzryjEntity> page = service.queryPage(param,false);
        IPage<ZzryjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ZzryjVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ZzryjEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Zzryj-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refZzryjData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ZzryjVO>> refZzryjData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ZzryjEntity> page = service.queryPage(param,false);
        IPage<ZzryjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ZzryjVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("参照印章登记新增")
    @RequestMapping(value = "/addByYzdj", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ZzryjVO> addByYzdj(@RequestParam Long id) {
        YzdjEntity yzdjEntity = yzdjService.selectById(id);
        ZzryjEntity vo = new ZzryjEntity();
        if (yzdjEntity != null) {
            vo.setYzbhCode(yzdjEntity.getBillCode());
            vo.setYzlbId(yzdjEntity.getYzlbId());
            vo.setYzlbName(yzdjEntity.getYzlbName());
            vo.setYzjbId(yzdjEntity.getYzjbId());
            vo.setYzjbName(yzdjEntity.getYzjbName());
            vo.setYylxId(yzdjEntity.getYylxId());
            vo.setYylxName(yzdjEntity.getYylxName());
            vo.setKzzy(yzdjEntity.getKzzy());
            vo.setSsdwId(yzdjEntity.getSsdwId());
            vo.setSsdwName(yzdjEntity.getSsdwName());
            vo.setDqbgrId(yzdjEntity.getDqbgrId());
            vo.setDqbgrName(yzdjEntity.getDqbgrName());
            vo.setKzsjTime(yzdjEntity.getKzsjTime());
            vo.setBaqk(yzdjEntity.getBaqk());
            vo.setBasjTime(yzdjEntity.getBasjTime());
            vo.setBadwName(yzdjEntity.getBadwName());
            vo.setScdwName(yzdjEntity.getScdwName());

        }

        return CommonResponse.success("查询详情数据成功！", BeanMapper.map(vo, ZzryjVO.class));
    }
}
