package com.ejianc.business.sealm.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.YzffEntity;
import com.ejianc.business.sealm.bean.ZzryjEntity;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.service.IYzffService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("yzff") 
public class YzffBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IYzdjService yzdjService;

	@Autowired
	private IYzffService service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		YzffEntity yzffEntity =service.getById(billId);
		Long Id =yzffEntity.getLyrId();
		String name =yzffEntity.getLyrName();

		//根据ID修改印章发放
		LambdaUpdateWrapper<YzffEntity> updateWrapper = new LambdaUpdateWrapper<>();
		LambdaUpdateWrapper<YzdjEntity> DjWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzffEntity::getZt,1);
		updateWrapper.eq(YzffEntity::getId,billId);
		service.update(updateWrapper);
		String code=yzffEntity.getYzbhCode();
        DjWrapper.set(YzdjEntity::getDqbgrId,Id);
        DjWrapper.set(YzdjEntity::getDqbgrName,name);
        DjWrapper.eq(YzdjEntity::getBillCode,code);
		yzdjService.update(DjWrapper);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		if (billId !=null){
			YzffEntity yzffEntity =service.selectById(billId);
			if (yzffEntity!=null){
				LambdaUpdateWrapper<YzffEntity> wrapper = new LambdaUpdateWrapper<>();
				wrapper.set(YzffEntity::getZt, 0);
				//	wrapper.set(TrainXxgzEntity::getIsStop, BidCommonConsts.YES);
				service.update(wrapper);
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
