package com.ejianc.business.sealm.controller;

import java.io.Serializable;

import com.ejianc.business.sealm.bean.YzsqEntity;
import com.ejianc.business.sealm.consts.SealmYzztConsts;
import com.ejianc.business.sealm.service.IYzsqService;
import com.ejianc.business.sealm.vo.YzsqVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.sealm.consts.SealmCommonConsts;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.vo.YzdjVO;

/**
 * 印章登记
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("yzdj")
public class YzdjController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "YZDJ_CODE";//此处需要根据实际修改
    
    @Autowired
    private IYzdjService service;

    @Autowired
    private IYzsqService yzsqService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YzdjVO> saveOrUpdate(@RequestBody YzdjVO saveorUpdateVO) {
    	YzdjEntity entity = BeanMapper.map(saveorUpdateVO, YzdjEntity.class);
    	if(saveorUpdateVO.getBillCode()==null){
            if(entity.getId() == null || entity.getId() == 0){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if(billCode.isSuccess()) {
                    //      entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	YzdjVO vo = BeanMapper.map(entity, YzdjVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YzdjVO> queryDetail(Long id) {
    	YzdjEntity entity = service.selectById(id);
    	YzdjVO vo = BeanMapper.map(entity, YzdjVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YzdjVO> vos) {
        service.removeByIds(vos.stream().map(YzdjVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<YzdjVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
       // param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Map<String, Parameter> params = param.getParams();
        if (!params.containsKey("orgId")){
            param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<YzdjEntity> page = service.queryPage(param,false);
        IPage<YzdjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), YzdjVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<YzdjEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Yzdj-export.xlsx", beans, response);
    }

   /* *//**
     * @Description 参照

     * @Return void
     *//*
    @RequestMapping(value = "/refYzdjData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<YzdjVO>> refYzdjData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        *//** 租户隔离 *//*
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            *//** 处理condition *//*
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<YzdjEntity> page = service.queryPage(param,false);
        IPage<YzdjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), YzdjVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
*/

    /**
     * @Description 参照

     * @Return void
     */
    @RequestMapping(value = "/refYzdjData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<YzdjVO>> refYzsqData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("yylxName");  //印章类型
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            Integer mark=con.getInteger("zt");
            switch(mark){
                case 0:
                    param.getParams().put("zt", new Parameter(QueryParam.EQ, SealmYzztConsts.ZBZK));
                    break;
                case 1:
                    param.getParams().put("zt", new Parameter(QueryParam.EQ, SealmYzztConsts.ZCFF));
                    break;
                case 2:
                    param.getParams().put("zt", new Parameter(QueryParam.EQ, SealmYzztConsts.WJDG));
                    break;
                case 3:
                    param.getParams().put("zt", new Parameter(QueryParam.EQ, SealmYzztConsts.YXH));
                    break;
                case 5:
                    param.getParams().put("zt", new Parameter(QueryParam.EQ, SealmYzztConsts.YC));
                    break;
            }
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 印章状态-总部在库 */

        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 已通过 **/
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        IPage<YzdjEntity> page = service.queryPage(param,false);
        IPage<YzdjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), YzdjVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @ApiOperation("参照印章申请新增")
    @RequestMapping(value = "/addByYzsq", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YzdjVO> addByYzsq(@RequestParam Long id) {
        YzsqEntity yzsqEntity = yzsqService.selectById(id);
        YzdjEntity vo = new YzdjEntity();
        if (yzsqEntity != null) {
            vo.setYzsqId(yzsqEntity.getId());
            vo.setYzlbId(yzsqEntity.getYzlbId());
            vo.setYzlbName(yzsqEntity.getYzlbName());
            vo.setYzjbId(yzsqEntity.getYzjbId());
            vo.setYzjbName(yzsqEntity.getYzjbName());
            vo.setYylxId(yzsqEntity.getYylxId());
            vo.setYylxName(yzsqEntity.getYylxName());
            vo.setKzzy(yzsqEntity.getKzzy());
            vo.setSsdwId(yzsqEntity.getApplyOrganId());
            vo.setSsdwName(yzsqEntity.getApplyOrganName());
            //是否来源于印章申请,默认是0
            vo.setSfYzsq(SealmCommonConsts.YES);
            vo.setBzdwId(yzsqEntity.getOrgId());
            vo.setBzdwName(yzsqEntity.getOrgName());
        }

        return CommonResponse.success("查询详情数据成功！", BeanMapper.map(vo, YzdjVO.class));
    }


}
