package com.ejianc.business.sealm.controller;

import java.io.Serializable;

import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.YzffEntity;
import com.ejianc.business.sealm.bean.YzsqEntity;
import com.ejianc.business.sealm.consts.SealmCommonConsts;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.service.IYzffService;
import com.ejianc.business.sealm.service.IYzsqService;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sealm.bean.YzhsEntity;
import com.ejianc.business.sealm.service.IYzhsService;
import com.ejianc.business.sealm.vo.YzhsVO;

/**
 * 印章回收
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("yzhs")
public class YzhsController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "YZDJ_CODE";//此处需要根据实际修改
    
    @Autowired
    private IYzhsService service;

    @Autowired
    private IYzdjService yzdjService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YzhsVO> saveOrUpdate(@RequestBody YzhsVO saveorUpdateVO) {
    	YzhsEntity entity = BeanMapper.map(saveorUpdateVO, YzhsEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
               // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	YzhsVO vo = BeanMapper.map(entity, YzhsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YzhsVO> queryDetail(Long id) {
    	YzhsEntity entity = service.selectById(id);
    	YzhsVO vo = BeanMapper.map(entity, YzhsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YzhsVO> vos) {
        service.removeByIds(vos.stream().map(YzhsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<YzhsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("yzbhCode");
        fuzzyFields.add("kzzy");
        fuzzyFields.add("bgrName");
        fuzzyFields.add("hsbgrName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
       //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Map<String, Parameter> params = param.getParams();
        if (!params.containsKey("orgId")){
            param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<YzhsEntity> page = service.queryPage(param,false);
        IPage<YzhsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), YzhsVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<YzhsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Yzhs-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refYzhsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<YzhsVO>> refYzhsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<YzhsEntity> page = service.queryPage(param,false);
        IPage<YzhsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), YzhsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/selectgrant", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YzhsVO> addByInfotrack(@RequestParam Long id) {
        YzdjEntity yzdjEntity = yzdjService.selectById(id);
        YzhsEntity vo = new YzhsEntity();
        if (yzdjEntity != null) {
            vo.setYzbhCode(yzdjEntity.getBillCode());
            vo.setYzlbId(yzdjEntity.getYzlbId());
            vo.setYzlbName(yzdjEntity.getYzlbName());
            vo.setYzjbId(yzdjEntity.getYzjbId());
            vo.setYzjbName(yzdjEntity.getYzjbName());
            vo.setYylxId(yzdjEntity.getYylxId());
            vo.setYylxName(yzdjEntity.getYylxName());
            vo.setKzzy(yzdjEntity.getKzzy());
            vo.setSsdwId(yzdjEntity.getSsdwId());
            vo.setSsdwName(yzdjEntity.getSsdwName());
            vo.setKzsjTime(yzdjEntity.getKzsjTime());
            vo.setBaqk(yzdjEntity.getBaqk());
            vo.setBasjTime(yzdjEntity.getBasjTime());
            vo.setBadwName(yzdjEntity.getBadwName());
            vo.setScdwName(yzdjEntity.getScdwName());
            vo.setBgrId(yzdjEntity.getDqbgrId());
            vo.setBgrName(yzdjEntity.getDqbgrName());
        }

        return CommonResponse.success("查询详情数据成功！", BeanMapper.map(vo, YzhsVO.class));
    }
}
