package com.ejianc.business.sealm.controller.api;

import java.util.List;

import com.ejianc.business.sealm.bean.YysqEntity;
import com.ejianc.business.sealm.service.IYysqService;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/instore/")
public class InstoreApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "YYSQ_CODE";//此处需要根据实际修改

    @Autowired
    private IYysqService service;


    /**
     * @Author liyongjia
     * @Date 2020/6/10  新增用印申请
     * @Description updatePayment
     * @Param [vos]
     * @Return 
     */
    @RequestMapping(value = "addYysq", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> addYysq(@RequestBody YysqVO vo) {
        if(null != vo) {
            YysqEntity entity = BeanMapper.map(vo, YysqEntity.class);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            entity.setMessageFrom(0);  //单据来源,0推送
            service.saveOrUpdate(entity,false);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }


}
