/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sealm.controller;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sealm.bean.YysqEntity;
import com.ejianc.business.sealm.service.IYysqService;
import com.ejianc.business.sealm.utils.AESUtil;
import com.ejianc.business.sealm.vo.AttachFile;
import com.ejianc.business.sealm.vo.QjykyVO;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"yysq"})
public class YysqController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "YYSQ_CODE";
    private static final String PREFIX_URL = "https://zzyj.ca.qunje.com:8008/stampInterface/";
    @Autowired
    private IYysqService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<YysqVO> saveOrUpdate(@RequestBody YysqVO saveorUpdateVO) {
        YysqEntity entity = (YysqEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, YysqEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        YysqVO vo = (YysqVO)BeanMapper.map((Object)((Object)entity), YysqVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<YysqVO> queryDetail(Long id) {
        YysqEntity entity = (YysqEntity)((Object)this.service.selectById(id));
        YysqVO vo = (YysqVO)BeanMapper.map((Object)((Object)entity), YysqVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YysqVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<YysqVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YysqVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Yysq-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refYysqData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<YysqVO>> refYysqData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YysqVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/testQjyky"}, method={RequestMethod.GET})
    @ResponseBody
    public String testQjyky() {
        String createUrl = "https://zzyj.ca.qunje.com:8008/stampInterface/order/addYZSQAndSealOrder";
        ArrayList<QjykyVO> details = new ArrayList<QjykyVO>();
        QjykyVO detail = new QjykyVO();
        detail.setCaseId("444");
        detail.setSessionId("444");
        detail.setSealNo("2019062419336378");
        detail.setSealCount("10000");
        details.add(detail);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("caseId", "444");
        param.put("formNo", "YZ-20180613-1234");
        param.put("title", "\u6587\u4ef6\u540d\u79f0144");
        param.put("fingerNo", "10002");
        param.put("sealUserName", "\u5f20\u4e09");
        param.put("phoneNumber", "12312341234");
        param.put("vertifyCode", "123456");
        param.put("attachfile", new ArrayList());
        param.put("applicantName", "\u5f20\u4e09");
        param.put("depName", "\u8f6f\u4ef6\u90e8");
        param.put("details", details);
        ArrayList<AttachFile> attachFileList = new ArrayList<AttachFile>();
        AttachFile attachFile = new AttachFile();
        attachFile.setCaseId("444");
        attachFile.setFileExt("jpg");
        attachFile.setFileName("123");
        attachFile.setFilePath("https://dev.qunje.com/stamp/attchFile/getFilePath?type=1&id=BDADBD60-4724-4DE1-87D7-A7E6B52C99C9&uid=ff094f58-9afe-4aeb-8240-b3f30e424fb9");
        attachFileList.add(attachFile);
        param.put("attachfile", attachFileList);
        String jsonString = JSONObject.toJSONString(param);
        String resultStr = AESUtil.encrypt((String)jsonString, (String)AESUtil.key);
        String json = HttpUtil.post((String)createUrl, (String)resultStr);
        return json;
    }

    @RequestMapping(value={"/getFileList"}, method={RequestMethod.GET})
    @ResponseBody
    public String getFileList() {
        String url = "https://zzyj.ca.qunje.com:8008/stampInterface/order/ getFileList";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("caseId", "f785efeb6f52469fa9e0bfae3001f253");
        param.put("sessionId", "5730b8cf02ad43c7b94ba67287d41c2c");
        String jsonString = JSONObject.toJSONString(param);
        String result = HttpUtil.post((String)url, (String)jsonString);
        return result;
    }

    @RequestMapping(value={"/getStampInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public String getStampInfo() {
        String url = "https://zzyj.ca.qunje.com:8008/stampInterface/order/getStampInfo";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("caseId", "HBJS-OASealUseApply-2");
        param.put("sessionId", "HBJS-OASealUseApplyItem-2");
        String jsonString = JSONObject.toJSONString(param);
        String result = HttpUtil.post((String)url, (String)jsonString);
        return result;
    }
}

