/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sealm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.YzhsEntity;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.service.IYzhsService;
import com.ejianc.business.sealm.vo.YzhsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"yzhs"})
public class YzhsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "YZDJ_CODE";
    @Autowired
    private IYzhsService service;
    @Autowired
    private IYzdjService yzdjService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<YzhsVO> saveOrUpdate(@RequestBody YzhsVO saveorUpdateVO) {
        YzhsEntity entity = (YzhsEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, YzhsEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        YzhsVO vo = (YzhsVO)BeanMapper.map((Object)((Object)entity), YzhsVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<YzhsVO> queryDetail(Long id) {
        YzhsEntity entity = (YzhsEntity)((Object)this.service.selectById(id));
        YzhsVO vo = (YzhsVO)BeanMapper.map((Object)((Object)entity), YzhsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YzhsVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<YzhsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("yzbhCode");
        fuzzyFields.add("kzzy");
        fuzzyFields.add("bgrName");
        fuzzyFields.add("hsbgrName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map params = param.getParams();
        if (!params.containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YzhsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Yzhs-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refYzhsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<YzhsVO>> refYzhsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YzhsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/selectgrant"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<YzhsVO> addByInfotrack(@RequestParam Long id) {
        YzdjEntity yzdjEntity = (YzdjEntity)((Object)this.yzdjService.selectById(id));
        YzhsEntity vo = new YzhsEntity();
        if (yzdjEntity != null) {
            vo.setYzbhCode(yzdjEntity.getBillCode());
            vo.setYzlbId(yzdjEntity.getYzlbId());
            vo.setYzlbName(yzdjEntity.getYzlbName());
            vo.setYzjbId(yzdjEntity.getYzjbId());
            vo.setYzjbName(yzdjEntity.getYzjbName());
            vo.setYylxId(yzdjEntity.getYylxId());
            vo.setYylxName(yzdjEntity.getYylxName());
            vo.setKzzy(yzdjEntity.getKzzy());
            vo.setSsdwId(yzdjEntity.getSsdwId());
            vo.setSsdwName(yzdjEntity.getSsdwName());
            vo.setKzsjTime(yzdjEntity.getKzsjTime());
            vo.setBaqk(yzdjEntity.getBaqk());
            vo.setBasjTime(yzdjEntity.getBasjTime());
            vo.setBadwName(yzdjEntity.getBadwName());
            vo.setScdwName(yzdjEntity.getScdwName());
            vo.setBgrId(yzdjEntity.getDqbgrId());
            vo.setBgrName(yzdjEntity.getDqbgrName());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)vo), YzhsVO.class));
    }
}

