package com.ejianc.business.sealm.controller;

import java.io.Serializable;

import cn.hutool.http.HttpUtil;
import com.ejianc.business.sealm.utils.AESUtil;
import com.ejianc.business.sealm.utils.YZMUtil;
import com.ejianc.business.sealm.vo.AttachFile;
import com.ejianc.business.sealm.vo.QjykyVO;
import com.ejianc.business.sealm.vo.YzsqSealOrderVo;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.vo.ZcyysqVO;

/**
 * 支出合同用印申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("zcyysq")
public class ZcyysqController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "ZCHTYY_CODE";//此处需要根据实际修改

    private static final String PREFIX_URL = "https://zzyj.ca.qunje.com:8008/stampInterface/";

    @Autowired
    private IZcyysqService service;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ZcyysqVO> saveOrUpdate(@RequestBody ZcyysqVO saveOrUpdateVO) {
    	ZcyysqEntity entity = BeanMapper.map(saveOrUpdateVO, ZcyysqEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
           //     entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setCreateUserName(sessionManager.getUserContext().getUserName());  //创建人
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            entity.setUpdateUserName(sessionManager.getUserContext().getUserName());  //修改人
        }
    	service.saveOrUpdate(entity, false);
    	ZcyysqVO vo = BeanMapper.map(entity, ZcyysqVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ZcyysqVO> queryDetail(Long id) {
    	ZcyysqEntity entity = service.selectById(id);
    	ZcyysqVO vo = BeanMapper.map(entity, ZcyysqVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ZcyysqVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ZcyysqVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ZcyysqVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ZcyysqVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("billCode"); //单据编码
        fuzzyFields.add("htCode");  //合同编号
        fuzzyFields.add("yzName");  //印章名称
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ZcyysqEntity> page = service.queryPage(param,false);
        IPage<ZcyysqVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ZcyysqVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ZcyysqEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Zcyysq-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refZcyysqData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ZcyysqVO>> refZcyysqData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ZcyysqEntity> page = service.queryPage(param,false);
        IPage<ZcyysqVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ZcyysqVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description 2.8 创建申请并授权接口
     * @Return void
     */
    @RequestMapping(value = "/testQjyky", method = RequestMethod.GET)
    @ResponseBody
    public void testQjyky(Long id) {

//调用群杰接口，发送短信码
        ZcyysqEntity zcyysqEntity = service.selectById(id);
        YzsqSealOrderVo yzsqSealOrderVo = new YzsqSealOrderVo();
        if (zcyysqEntity != null) {
            if ("1472850976309252098".equals(zcyysqEntity.getYzlbId().toString())) {  //判断是印控仪才走下面的代码
                // 请求url
                String createUrl = PREFIX_URL + "order/addYZSQAndSealOrder";
                String caseId =	zcyysqEntity.getId().toString();  //当前办理事项ID,默认是申请表code+id形式
                String vertifyCode = YZMUtil.GenerateSafeCode();  //生成六位随机验证码
                yzsqSealOrderVo.setWorkflowName("t_seal_zcyysq");  //表名
                yzsqSealOrderVo.setCaseId(caseId);
                yzsqSealOrderVo.setTitle("支出合同用印申请调永群杰验证码");
                yzsqSealOrderVo.setFingerNo(zcyysqEntity.getCreateUserCode());  //授权人账号
              //  yzsqSealOrderVo.setSealUserName(zcyysqEntity.getCreateUserName());  //实际用印人姓名
                yzsqSealOrderVo.setFormNo(zcyysqEntity.getBillCode());  //流程单号
                yzsqSealOrderVo.setVertifyCode(vertifyCode);
            /*    yzsqSealOrderVo.setApplicantName(zcyysqEntity.getJbrName());  //申请人姓名
                yzsqSealOrderVo.setDepName(zcyysqEntity.getOrgName());  //组织
                yzsqSealOrderVo.setDescription(zcyysqEntity.getYyReason());  //用印事由
                yzsqSealOrderVo.setPhoneNumber(zcyysqEntity.getJbrTel());  //经办人手机号
                yzsqSealOrderVo.setIsTakeOut(zcyysqEntity.getSfWdgz().toString());  //是否外带公章,1是，0否*/
                //子表信息封装
                List<QjykyVO> qjykyVOList = new ArrayList<QjykyVO>();
                QjykyVO qjykyVO = new QjykyVO();
                qjykyVO.setSessionId(zcyysqEntity.getId().toString());  //授权明细ID
                qjykyVO.setCaseId(caseId);
                qjykyVO.setSealNo("2019062419336378");  //设备编码
                qjykyVO.setSealCount(zcyysqEntity.getYycs().toString());  //申请次数
                qjykyVOList.add(qjykyVO);

                yzsqSealOrderVo.setDetail(qjykyVOList);  //

                // 转换为json字符串
                String jsonString = JSONObject.toJSONString(yzsqSealOrderVo);
                // 加密
                String resultStr = AESUtil.encrypt(jsonString, AESUtil.key);
                // 发送请求
                String json = HttpUtil.post(createUrl, resultStr);

                JSONObject jsonObject =JSONObject.parseObject(json);
                String code = jsonObject.getString("errCode");
                //判断是否调用成功，不成功就终结掉操作
                if ("200".equals(code)) {
                    zcyysqEntity.setYzm(vertifyCode);  //验证码发送成功后，将验证码同步到本地库
                    service.updateById(zcyysqEntity);
                } else {
                    //打印报错
                    logger.info(json);
                    System.out.println(json);
                }



            }
        }




    }
}
