package com.ejianc.business.sealm.controller.api;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.sealm.bean.YysqEntity;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.service.IYysqService;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/instore/")
public class InstoreApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "YYSQ_CODE";//此处需要根据实际修改

    @Autowired
    private IYysqService service;

    @Autowired
    private IYzdjService djservice;



    /**
     * @Author liyongjia
     * @Date 2020/6/10  新增用印申请
     * @Description updatePayment
     * @Param [vos]
     * @Return 
     */
    @RequestMapping(value = "addYysq", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> addYysq(@RequestBody YysqVO vo) {
        if(null != vo) {
            String BILL_CODE = "YYSQ_CODE";//此处需要根据实际修改
            YysqEntity entity = BeanMapper.map(vo, YysqEntity.class);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            service.saveOrUpdate(entity,false);
            logger.info("接收到投标报名Task参数：{我要保存啦}" +vo);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }


    /**
     * @Author chenchunlei
     * @Date 2021/1/26  新增印章登记
     * @Description updatePayment
     * @Param [vos]
     * @Return
     */
    @RequestMapping(value = "addYzdj", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> addYzdj(@RequestBody YzdjVO vo) {
        if(null != vo) {
            String BILL_CODE = "YZDJ_CODE";//此处需要根据实际修改
            YzdjEntity entity = BeanMapper.map(vo, YzdjEntity.class);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            djservice.saveOrUpdate(entity,false);
            logger.info("接收到投标参数：{我要保存啦}");
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }

    /*
    * 根据印章编号查询保管人*/
    @RequestMapping(value = "selectYzBgr", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> selectYzBgr(@RequestBody String yzbh) {
        Long Bgrid=null;
        if(null != yzbh) {
           LambdaQueryWrapper<YzdjEntity> queryWrapper =new LambdaQueryWrapper<>();
           queryWrapper.eq(YzdjEntity::getYzbh,yzbh);
           YzdjEntity yzdj =djservice.getOne(queryWrapper);
           Bgrid =yzdj.getDqbgrId();
        }
        return CommonResponse.success("查询成功！",Bgrid);
    }
}
