package com.ejianc.business.sealm.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sealm.bean.YzdjEntity;
import com.ejianc.business.sealm.bean.YzffEntity;
import com.ejianc.business.sealm.consts.SealmYzztConsts;
import com.ejianc.business.sealm.service.IYzdjService;
import com.ejianc.business.sealm.service.IYzffService;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Map;


@Service("yzff")
public class YzffBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IYzdjService yzdjService;

	@Autowired
	private IYzffService service;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("提交前回调：{}",1111);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		YzffEntity yzffEntity =service.getById(billId);

		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getZt, SealmYzztConsts.WJDG);
		updateWrapper.eq(YzdjEntity::getBillCode, yzffEntity.getYzbhCode());
		yzdjService.update(updateWrapper);


		LambdaUpdateWrapper<YzdjEntity> DjWrapper = new LambdaUpdateWrapper<>();
		DjWrapper.set(YzdjEntity::getDqbgrId,yzffEntity.getBgrId());
		DjWrapper.set(YzdjEntity::getDqbgrName,yzffEntity.getBgrName());
		DjWrapper.eq(YzdjEntity::getBillCode,yzffEntity.getYzbhCode());
		boolean a=yzdjService.update(DjWrapper);
		logger.info("接收到投标报名Task参数：{}",a);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		if (billId !=null){
			YzffEntity yzffEntity =service.selectById(billId);
			if (yzffEntity!=null){
				LambdaUpdateWrapper<YzdjEntity> wrapper = new LambdaUpdateWrapper<>();
				wrapper.set(YzdjEntity::getZt, SealmYzztConsts.ZBZK);
				wrapper.eq(YzdjEntity::getBillCode,yzffEntity.getYzbhCode());
				yzdjService.update(wrapper);
			}
		}
		logger.info("接收到投标报名Task参数2222：{}");
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		YzffEntity yzffEntity =service.getById(billId);

		LambdaUpdateWrapper<YzdjEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(YzdjEntity::getZt, SealmYzztConsts.ZCFF);
		updateWrapper.set(YzdjEntity::getDqbgrId,yzffEntity.getBgrId());
		updateWrapper.set(YzdjEntity::getDqbgrName,yzffEntity.getBgrName());
		updateWrapper.set(YzdjEntity::getGldwId,yzffEntity.getBgdwId());
		updateWrapper.set(YzdjEntity::getGldwName,yzffEntity.getBgdwName());
		updateWrapper.eq(YzdjEntity::getBillCode,yzffEntity.getYzbhCode());
		boolean a=yzdjService.update(updateWrapper);
		logger.info("印章登记更新结果：{}",a);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
