package com.ejianc.business.sealm.controller.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sealm.bean.YzsqSealOrderEntity;
import com.ejianc.business.sealm.utils.AESUtil;
import com.ejianc.business.sealm.utils.YZMUtil;
import com.ejianc.business.sealm.vo.QjykyVO;
import com.ejianc.business.sealm.vo.YzsqSealOrderVo;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author Chen chunlei
 *
 * @Date 2022/4/8/008 8:34
 */
public class YKYUtil {
    private static final String PREFIX_URL = "https://zzyj.ca.qunje.com:8008/stampInterface/";
    public static YzsqSealOrderVo yzsqSealOrderVoMapping(YzsqSealOrderEntity entity){

        YzsqSealOrderVo yzsqSealOrderVo = new YzsqSealOrderVo();

        String vertifyCode = YZMUtil.GenerateSafeCode();  //生成六位随机验证码
        String caseId =	entity.getBillCode() + entity.getId();  //当前办理事项ID,默认是申请表code+id形式
        yzsqSealOrderVo.setWorkflowName(entity.getWorkflowName());  //表名
        yzsqSealOrderVo.setCaseId(caseId);
        yzsqSealOrderVo.setTitle(entity.getTitle());
        yzsqSealOrderVo.setFingerNo(entity.getCreateUserCode());  //授权人账号
        yzsqSealOrderVo.setSealUserName(entity.getCreateUserName());  //实际用印人姓名
        yzsqSealOrderVo.setFormNo(entity.getBillCode());  //流程单号
        yzsqSealOrderVo.setVertifyCode(vertifyCode);
        yzsqSealOrderVo.setApplicantName(entity.getJbrName());  //申请人姓名
        yzsqSealOrderVo.setDepName(entity.getOrgName());  //组织
        yzsqSealOrderVo.setDescription(entity.getYyReason());  //用印事由
        yzsqSealOrderVo.setPhoneNumber(entity.getJbrTel());  //经办人手机号
        if (entity.getSfWdgz() != null) {
            yzsqSealOrderVo.setIsTakeOut(entity.getSfWdgz().toString());  //是否外带公章,1是，0否
        }
        //子表信息封装
        List<QjykyVO> qjykyVOList = new ArrayList<QjykyVO>();
        QjykyVO qjykyVO = new QjykyVO();
        qjykyVO.setSessionId(entity.getId().toString());  //授权明细ID
        qjykyVO.setCaseId(caseId);
        qjykyVO.setSealNo(entity.getYzbhName());  //设备编码
        qjykyVO.setSealCount(entity.getYycs());  //申请次数
        qjykyVOList.add(qjykyVO);
        yzsqSealOrderVo.setDetails(qjykyVOList);  //


        return yzsqSealOrderVo;
    }
    public static JSONObject yzsqSealOrderVoSend(YzsqSealOrderVo yzsqSealOrderVo){
        // 请求url
        String createUrl = PREFIX_URL + "order/addYZSQAndSealOrder";
        // 转换为json字符串
        String jsonString = JSONObject.toJSONString(yzsqSealOrderVo);
        // 加密
        byte[] resultStr = AESUtil.encrypt(jsonString, AESUtil.key);
        //发起请求并接收返回信息
        String json = AESUtil.http(createUrl, resultStr);

        JSONObject jsonObject =JSONObject.parseObject(json);
        return jsonObject;
    }

}
