package com.ejianc.business.sealm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.bean.YzsqSealOrderEntity;
import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.controller.utils.YKYUtil;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.utils.SMS;
import com.ejianc.business.sealm.vo.YzsqSealOrderVo;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("zcyysq") 
public class ZcyysqBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IZcyysqService service;
	@Autowired
	private IInstoreApi instoreApi;

	@Autowired
	private IUserApi userApi;

	@Autowired
	private IThirdSystemApi thirdSystemApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		logger.info("合同用印申请--提交完回调开始");
		//调用群杰接口
		ZcyysqEntity zcyysqEntity = service.selectById(billId);
		if (zcyysqEntity != null && "1472850976309252098".equals(zcyysqEntity.getYzlbId().toString())) {  //判断是印控仪才走下面的代码

			//此YzsqSealOrderEntity为特定，如果字段不一致，请在下面代码重新赋值
			YzsqSealOrderEntity map = BeanMapper.map(zcyysqEntity, YzsqSealOrderEntity.class);
			map.setWorkflowName("t_seal_zcyysq");//表名
			map.setTitle("合同用印申请调用群杰验证码");
			YzsqSealOrderVo yzsqSealOrderVo = YKYUtil.yzsqSealOrderVoMapping(map);
			//CommonResponse<String> qunjeToken = thirdSystemApi.getQunjeToken("test", "123456a@", false);
			JSONObject jsonObject = YKYUtil.yzsqSealOrderVoSend(yzsqSealOrderVo);
			logger.info("调用群杰接口接收到的Json，{}",jsonObject);

			String code = jsonObject.getString("errCode");
			//判断是否调用成功，不成功就终结掉操作
			if ("0".equals(code)||"200".equals(code)) {
				zcyysqEntity.setYzm(yzsqSealOrderVo.getVertifyCode());  //验证码发送成功后，将验证码同步到本地库
				service.updateById(zcyysqEntity);
				//短信内容
				String context="您的电子签署验证码为："+yzsqSealOrderVo.getVertifyCode()+" 【郑州一建】";
				//印章编号获取保管人手机号
				CommonResponse<Long> bgrid=instoreApi.selcetYzBgr(map.getYzbhName());
				Long id = bgrid.getData();
				CommonResponse<UserVO> vo =userApi.findUserByUserId(id);
				UserVO vo1=vo.getData();
				String moblie =vo1.getUserMobile();
				//发送验证码
				SMS.setSendSms(moblie,context);
			}

		}
		logger.info("合同用印申请--提交完回调结束");
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		//return CommonResponse.error("此流程不支持撤回！");
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
