/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sealm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.api.IContractFillingApi;
import com.ejianc.business.sealm.bean.FillingEntity;
import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.mapper.ZcyysqSignatureMapper;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.service.IZcyysqSignatureService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="zcyysqSignatureService")
public class ZcyysqSignatureServiceImpl
implements IZcyysqSignatureService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IZcyysqService service;
    @Autowired
    IZcyysqSignatureService izcyysqSignatureService;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private ZcyysqSignatureMapper mapper;
    @Autowired
    private IContractFillingApi fillingApi;

    @Override
    public CommonResponse<String> relieveContract(Long id, String signatureStatus, String refCode) {
        this.logger.info("\u66f4\u65b0\u7528\u5370\u7533\u8bf7\u5408\u540c\u72b6\u6001\uff0c\u5165\u53c2--id\uff1b{}\uff0csignatureStatus\uff1a{}\uff0crefCode\uff1a{}", new Object[]{id, signatureStatus, refCode});
        ZcyysqEntity zcyysqEntity = (ZcyysqEntity)((Object)this.service.selectById(id));
        if (zcyysqEntity != null) {
            if (signatureStatus.equals("4")) {
                zcyysqEntity.setSignatureStatus(signatureStatus);
                this.service.saveOrUpdate((Object)zcyysqEntity);
                if (zcyysqEntity.getHtId() != null) {
                    if (zcyysqEntity.getHtlxName().equals("\u65bd\u5de5\u5408\u540c")) {
                        this.mapper.updateSghtStatus(zcyysqEntity.getHtId(), new Date(), zcyysqEntity.getId());
                    } else {
                        FillingEntity fillingEntity = new FillingEntity();
                        if (zcyysqEntity.getHtlxName().equals("\u52b3\u52a1\u5206\u5305\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("laborSub");
                        } else if (zcyysqEntity.getHtlxName().equals("\u52b3\u52a1\u5206\u5305\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("laborSubChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u6750\u6599\u91c7\u8d2d\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractMaterial");
                        } else if (zcyysqEntity.getHtlxName().equals("\u6750\u6599\u91c7\u8d2d\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractMaterialChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u4e13\u4e1a\u5206\u5305\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("proSub");
                        } else if (zcyysqEntity.getHtlxName().equals("\u4e13\u4e1a\u5206\u5305\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("proSubChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u5546\u783c\u91c7\u8d2d\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractConcrete");
                        } else if (zcyysqEntity.getHtlxName().equals("\u5546\u783c\u91c7\u8d2d\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractConcreteChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("rmat");
                        } else if (zcyysqEntity.getHtlxName().equals("\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("rmatChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u5176\u4ed6\u652f\u51fa\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractOther");
                        } else if (zcyysqEntity.getHtlxName().equals("\u5176\u4ed6\u652f\u51fa\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractOtherChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u673a\u68b0\u8bbe\u5907\u5b89\u62c6\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractAC");
                        } else if (zcyysqEntity.getHtlxName().equals("\u673a\u68b0\u8bbe\u5907\u5b89\u62c6\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractACChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentRent");
                        } else if (zcyysqEntity.getHtlxName().equals("\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentRentChange");
                        } else if (zcyysqEntity.getHtlxName().equals("\u673a\u68b0\u8bbe\u5907\u91c7\u8d2d\u5408\u540c") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentPurchase");
                        } else if (zcyysqEntity.getHtlxName().equals("\u673a\u68b0\u8bbe\u5907\u91c7\u8d2d\u5408\u540c") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentPurchaseChange");
                        }
                        if (fillingEntity.getFillingType() != null) {
                            String s = JSONObject.toJSONString((Object)fillingEntity);
                            CommonResponse commonResponse = this.fillingApi.updateFilingStatus(s);
                        }
                    }
                }
            } else {
                zcyysqEntity.setSignatureStatus(signatureStatus);
                this.service.saveOrUpdate((Object)zcyysqEntity);
            }
        }
        return CommonResponse.success((String)"\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }

    @Override
    public Long updateSignFileId(Long id) {
        ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
        ContractVO cv = new ContractVO();
        ZcyysqEntity zcyysqEntity = (ZcyysqEntity)((Object)this.service.selectById(id));
        if (zcyysqEntity != null) {
            cv.setContractId(zcyysqEntity.getId());
            cv.setContractName(zcyysqEntity.getAttachmentFileName());
            cv.setBillType("BT220121000000005");
            cv.setSourceType("contract");
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\uff0c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{id, "\u65e0", signResp.getMsg()});
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25");
            }
            List fileList = (List)signResp.getData();
            if (CollectionUtils.isEmpty((Collection)fileList)) {
                throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f");
            }
            SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
            zcyysqEntity.setSignedFileId(signedFileInfo.getFileId());
            this.service.saveOrUpdate((Object)zcyysqEntity);
            return signedFileInfo.getFileId();
        }
        return null;
    }
}

