package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.mapper.SettlementCenterAlertInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 预警信息表
 *
 * @author generator
 */
@Service("settlementCenterAlertInfoService")
public class SettlementCenterAlertInfoServiceImpl extends BaseServiceImpl<SettlementCenterAlertInfoMapper, SettlementCenterAlertInfoEntity> implements ISettlementCenterAlertInfoService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SettlementCenterAlertInfoMapper mapper;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;



    @Override
    public void saveLastAlert(SettlementCenterDcDrwgrpInfoEntity alert) {
        String thirdNodeUserId = alert.getThirdNodeUserId();
        if (StringUtils.isNotEmpty(thirdNodeUserId)) {
            CommonResponse<List<BpmApproveHistoryInfo>> response = bpmApi.queryHistoryById(alert.getId());
            if (!response.isSuccess() || !(response.getData() != null) || !(response.getData().size() > 0)) {
                logger.info(alert.getId()+"获取审批信息错误");
                logger.info(response.getMsg());
                return;
            }

            String[] split = thirdNodeUserId.split(",");
            for (int i = 0; i < split.length; i++) {
                String s = split[i];
                SettlementCenterAlertInfoEntity entity = new SettlementCenterAlertInfoEntity();
                entity.setAlertLastTime(new Date());
                entity.setAlertNowTime(alert.getDesiredTime());
                entity.setProjectId(alert.getProjectId());
                entity.setAlertType(0);
                entity.setSettlementCenterMajor(alert.getSettlementCenterMajor());
                entity.setDcDrwgrpInfoName(alert.getDcDrwgrpInfoName());
                entity.setProjectCode(alert.getProjectCode());
                entity.setProjectName(alert.getProjectName());
                entity.setThirdNodeUserId(Long.parseLong(s));
                entity.setInfoId(alert.getId());
                entity.setInfoCode(alert.getDcDrwgrpInfoCode());
                entity.setClearFlag(0);
                entity.setMajorName(alert.getSettlementCenterMajorName());
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(Long.parseLong(s));
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    entity.setThirdNodeUserName(userByUserId.getData().getUserName());
                } else {
                    entity.setThirdNodeUserName(alert.getThirdNodeUserName().split(",")[i]);
                }
                logger.info("当前预警人:"+entity.getThirdNodeUserName()+";当前预警人ID:"+entity.getThirdNodeUserId());
                entity.setOrgId(alert.getOrgId());
                entity.setOrgCode(alert.getOrgCode());
                entity.setOrgName(alert.getOrgName());
                entity.setParentOrgId(alert.getParentOrgId());
                entity.setParentOrgCode(alert.getParentOrgCode());
                entity.setParentOrgName(alert.getParentOrgName());
                boolean flag = false;
                for (BpmApproveHistoryInfo datum : response.getData()) {
                    //节点该审批人员未审批
                    if ("结算中心专职".equals(datum.getApproveNode()) && datum.getApprover().equals(entity.getThirdNodeUserName()) && "审批中".equals(datum.getApprovalOutcome())) {
                        flag = true;
                    }
                }
                if (flag) {
                    List<SettlementCenterAlertInfoEntity> list = this.list(
                            new QueryWrapper<SettlementCenterAlertInfoEntity>().lambda()
                                    .eq(SettlementCenterAlertInfoEntity::getThirdNodeUserId, entity.getThirdNodeUserId())
                                    .eq(SettlementCenterAlertInfoEntity::getAlertType, 0)
                                    .eq(SettlementCenterAlertInfoEntity::getInfoId, alert.getId())
                    );
                    if (list != null && list.size() > 0){
                        continue;
                    }
                    this.saveOrUpdate(entity);
                }
            }
        }
    }

    @Override
    public List<SettlementCenterAlertInfoEntity> selectByUserId(Long thirdNodeUserId, Long major,List<Long> departmentIds,List<Long> commonOrgIds) {


        return mapper.selectAlertList(thirdNodeUserId, major ,commonOrgIds,departmentIds);
    }



    @Override
    public void saveNowAlert(SettlementCenterDcDrwgrpInfoEntity alert) {
        String thirdNodeUserId = alert.getThirdNodeUserId();
        if (StringUtils.isNotEmpty(thirdNodeUserId)) {
            CommonResponse<List<BpmApproveHistoryInfo>> response = bpmApi.queryHistoryById(alert.getId());
            if (!response.isSuccess() || !(response.getData() != null) || !(response.getData().size() > 0)) {
                logger.info(alert.getId()+"获取审批信息错误");
                logger.info(response.getMsg());
                return;
            }

            String[] split = thirdNodeUserId.split(",");
            for (int i = 0; i < split.length; i++) {
                String s = split[i];
                SettlementCenterAlertInfoEntity entity = new SettlementCenterAlertInfoEntity();
                entity.setAlertNowTime(alert.getDesiredTime());
                entity.setAlertLastTime(new Date());
                entity.setProjectId(alert.getProjectId());
                entity.setAlertType(1);
                entity.setSettlementCenterMajor(alert.getSettlementCenterMajor());
                entity.setDcDrwgrpInfoName(alert.getDcDrwgrpInfoName());
                entity.setProjectCode(alert.getProjectCode());
                entity.setProjectName(alert.getProjectName());
                entity.setThirdNodeUserId(Long.parseLong(s));
                entity.setInfoId(alert.getId());
                entity.setInfoCode(alert.getDcDrwgrpInfoCode());
                entity.setClearFlag(0);
                entity.setMajorName(alert.getSettlementCenterMajorName());
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(Long.parseLong(s));
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    entity.setThirdNodeUserName(userByUserId.getData().getUserName());
                } else {
                    entity.setThirdNodeUserName(alert.getThirdNodeUserName().split(",")[i]);
                }
                logger.info("当前预警人:"+entity.getThirdNodeUserName()+";当前预警人ID:"+entity.getThirdNodeUserId());
                entity.setOrgId(alert.getOrgId());
                entity.setOrgCode(alert.getOrgCode());
                entity.setOrgName(alert.getOrgName());
                entity.setParentOrgId(alert.getParentOrgId());
                entity.setParentOrgCode(alert.getParentOrgCode());
                entity.setParentOrgName(alert.getParentOrgName());
                boolean flag = false;
                for (BpmApproveHistoryInfo datum : response.getData()) {
                    //节点该审批人员未审批
                    if ("结算中心专职".equals(datum.getApproveNode()) && datum.getApprover().equals(entity.getThirdNodeUserName()) && "审批中".equals(datum.getApprovalOutcome())) {
                        flag = true;
                    }
                }
                if (flag) {
                    List<SettlementCenterAlertInfoEntity> list = this.list(
                            new QueryWrapper<SettlementCenterAlertInfoEntity>().lambda()
                                    .eq(SettlementCenterAlertInfoEntity::getThirdNodeUserId, entity.getThirdNodeUserId())
                                    .eq(SettlementCenterAlertInfoEntity::getAlertType, 1)
                                    .eq(SettlementCenterAlertInfoEntity::getInfoId, alert.getId())
                    );
                    if (list != null && list.size() > 0){
                        continue;
                    }
                    this.saveOrUpdate(entity);
                }
            }
        }
    }


}
