package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.*;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 结算中心卷册信息表
 *
 * @author generator
 */
@Service("settlementCenterDcDrwgrpInfoService")
public class SettlementCenterDcDrwgrpInfoServiceImpl extends BaseServiceImpl<SettlementCenterDcDrwgrpInfoMapper, SettlementCenterDcDrwgrpInfoEntity> implements ISettlementCenterDcDrwgrpInfoService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBpmApi iBpmApi;
    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;

    @Autowired
    private ISettlementCenterDrawPlanService drawPlanService;
    @Autowired
    private ISettlementCenterDrawPlanDetailService drawPlanDetailService;
    @Autowired
    private ISettlementCenterSystemDrwgrpService systemDrwgrpService;
    @Autowired
    private ISettlementCenterProjectMajorService projectMajorService;

    @Value("${common.env.base-host}")
    private String baseHost;
    private static final String PARENT_BILL_TYPE_CODE = "BT250121000000001";//系统产值单据类型编码



    @Override
    public List<Map> getRankingListForYear(Long major,List<Long> departmentIds,List<Long> commonOrgIds) {
        return infoMapper.getRankingListForYear(major,departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> getRankingListForMonth(Long major,List<Long> departmentIds,List<Long> commonOrgIds) {
        return infoMapper.getRankingListForMonth(major,departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> getRankingListWithOrder(Long major,List<Long> departmentIds,List<Long> commonOrgIds,String order){
        return infoMapper.getRankingListWithOrder(major,departmentIds,commonOrgIds,order);
    }

    @Override
    public List<Map> getProjectLedgerList(String order) {
        return infoMapper.getProjectLedgerList(order);
    }

    @Override
    public List<Map> getMajorLedgerList(String order) {
        return infoMapper.getMajorLedgerList(order);
    }

    @Override
    public List<Map> getProjectStatisticsLedgerList(List<String> projectIds, List<Long> departmentIds, List<Long> commonOrgIds,Integer pageStart, Integer pageSize) {
        return infoMapper.getProjectStatisticsLedgerList(projectIds,departmentIds,commonOrgIds,pageStart,pageSize);
    }

    @Override
    public Integer countProjectStatisticsLedgerList(List<String> projectIds, List<Long> departmentIds, List<Long> commonOrgIds) {
        return infoMapper.countProjectStatisticsLedgerList(projectIds,departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> queryAllProject(List<Long> departmentIds,List<Long> commonOrgIds) {
        return infoMapper.queryAllProject(departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> getMajorStatisticsLedgerList(Long major, List<Long> departmentIds, List<Long> commonOrgIds,Integer pageStart, Integer pageSize) {
        return infoMapper.getMajorStatisticsLedgerList(major,departmentIds,commonOrgIds,pageStart,pageSize);
    }

    @Override
    public Integer countMajorStatisticsLedgerList(Long major, List<Long> departmentIds, List<Long> commonOrgIds) {
        return infoMapper.countMajorStatisticsLedgerList(major,departmentIds,commonOrgIds);
    }

    @Override
    public List<SettlementCenterDcDrwgrpInfoVO> queryNeedAddDetailData() {
        return infoMapper.queryNeedAddDetailData();
    }


    @Override
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateDcDrwgrpInfo(SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getSettlementCenterMajor() == null){
            saveOrUpdateVO.setSettlementCenterMajor(saveOrUpdateVO.getMajorId());
        }
        String sourceUnitid = saveOrUpdateVO.getSourceUnitid();
        String sourceUnitname = saveOrUpdateVO.getSourceUnitname();
        SettlementCenterDcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class);
        SettlementCenterDcDrwgrpInfoEntity exist = getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, saveOrUpdateVO.getDcDrwgrpInfoId())
                .eq(SettlementCenterDcDrwgrpInfoEntity::getSystemId,saveOrUpdateVO.getSystemId())
        );
        if (exist != null) {
//            exist.setFirstNodeTime(new Date());
            exist.setOrgId(entity.getOrgId());
            exist.setOrgCode(entity.getOrgCode());
            exist.setOrgName(entity.getOrgName());
            exist.setParentOrgId(entity.getParentOrgId());
            exist.setParentOrgCode(entity.getParentOrgCode());
            exist.setParentOrgName(entity.getParentOrgName());
            exist.setProjectId(entity.getProjectId());
            exist.setProjectCode(entity.getProjectCode());
            exist.setProjectName(entity.getProjectName());
            exist.setDcDrwgrpInfoCode(entity.getDcDrwgrpInfoCode());
            exist.setDcDrwgrpInfoName(entity.getDcDrwgrpInfoName());
            updateById(exist);
        } else {
            SettlementCenterDcDrwgrpInfoEntity notUpgrade = getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, saveOrUpdateVO.getDcDrwgrpInfoCode())
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getWhetherUpgrade, 0)
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getSystemId,saveOrUpdateVO.getSystemId())
            );
            if (notUpgrade != null){
                entity.setWhetherUpgrade(1);
            }
            Long systemId = entity.getSystemId();
            if (systemId != null){
                logger.info("当前到图计划id为:"+systemId);
                SettlementCenterDrawPlanEntity settlementCenterDrawPlanEntity = drawPlanService.selectById(systemId);
                if (settlementCenterDrawPlanEntity != null){
                    logger.info("saveOrUpdateDcDrwgrpInfo-------1");
                    List<SettlementCenterDrawPlanDetailEntity> detailList = settlementCenterDrawPlanEntity.getSettlementCenterDrawPlanDetailList();
                    SettlementCenterDrawPlanDetailEntity settlementCenterDrawPlanDetailEntity = detailList.stream().filter(e -> entity.getDcDrwgrpInfoCode().contains(e.getDrwgrpCode())).findFirst().orElse(null);
                    if (settlementCenterDrawPlanDetailEntity != null){
                        logger.info("saveOrUpdateDcDrwgrpInfo-----2");
                        settlementCenterDrawPlanDetailEntity.setEndTime(saveOrUpdateVO.getDrawArriveDate() == null ? new Date() : saveOrUpdateVO.getDrawArriveDate());
                        drawPlanDetailService.updateById(settlementCenterDrawPlanDetailEntity);
                    }
                    SettlementCenterDrawPlanEntity drawPlanEntity = handlerDate(settlementCenterDrawPlanEntity);
                    drawPlanService.updateById(drawPlanEntity);
                }

                SettlementCenterSystemDrwgrpEntity one = systemDrwgrpService.getOne(
                        new QueryWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
                                .eq(SettlementCenterSystemDrwgrpEntity::getSystemId, systemId)
                                .eq(SettlementCenterSystemDrwgrpEntity::getDr, 0)
                                .last(" limit 0,1 ")
                );
                if (one != null){
                    //卷册加父级id
                    entity.setPid(one.getId());
                    if (StringUtils.isNotEmpty(sourceUnitid) && (one.getSourceUnitid() == null || !one.getSourceUnitid().contains(sourceUnitid))){
                        if (StringUtils.isNotEmpty(one.getSourceUnitid())) {
                            one.setSourceUnitid(one.getSourceUnitid()+","+sourceUnitid);
                            one.setSourceUnitname(one.getSourceUnitname()+","+sourceUnitname);
                        }else {
                            one.setSourceUnitid(sourceUnitid);
                            one.setSourceUnitname(sourceUnitname);
                        }
                        systemDrwgrpService.updateById(one);
                    }
                }else {
                    one = new SettlementCenterSystemDrwgrpEntity();
                    one.setFlowState(SettleFlowStateEnum.ONE.getCode());
                    one.setFlowStateName(SettleFlowStateEnum.ONE.getName());
                    one.setFirstNodeTime(new Date());
                    one.setDesiredTime(settlementCenterDrawPlanEntity.getCalEndTime());
                    one.setSystemId(systemId);
                    one.setSystemName(settlementCenterDrawPlanEntity.getSystemName());
                    one.setOrgId(entity.getOrgId());
                    one.setOrgCode(entity.getOrgCode());
                    one.setOrgName(entity.getOrgName());
                    one.setParentOrgId(entity.getParentOrgId());
                    one.setParentOrgCode(entity.getParentOrgCode());
                    one.setParentOrgName(entity.getParentOrgName());
                    one.setProjectId(entity.getProjectId());
                    one.setProjectCode(entity.getProjectCode());
                    one.setProjectName(entity.getProjectName());
                    one.setThirdNodeUserId(settlementCenterDrawPlanEntity.getStatisticalPerson() == null ? null : settlementCenterDrawPlanEntity.getStatisticalPerson().toString());
                    one.setFourthNodeUserId(settlementCenterDrawPlanEntity.getMajorManagerPerson() == null ? null : settlementCenterDrawPlanEntity.getMajorManagerPerson().toString());
                    one.setFifthNodeUserId(settlementCenterDrawPlanEntity.getProjectResponsiblePerson());
                    one.setSixthNodeUserId(settlementCenterDrawPlanEntity.getProjectContractPerson());
                    one.setSeventhNodeUserId(settlementCenterDrawPlanEntity.getCompositePerson());
                    one.setSettlementCenterMajor(settlementCenterDrawPlanEntity.getSettlementCenterMajor().toString());
                    one.setSettlementCenterMajorName(settlementCenterDrawPlanEntity.getSettlementCenterMajorName());
                    SettlementCenterProjectMajorEntity projectMajor = projectMajorService.getOne(
                            new QueryWrapper<SettlementCenterProjectMajorEntity>().lambda()
                                    .eq(SettlementCenterProjectMajorEntity::getProjectId, settlementCenterDrawPlanEntity.getProjectId())
                                    .eq(SettlementCenterProjectMajorEntity::getSettlementCenterMajor, settlementCenterDrawPlanEntity.getSettlementCenterMajor())
                                    .eq(SettlementCenterProjectMajorEntity::getDr, 0)
                    );
                    if (projectMajor != null){
                        one.setContractId(projectMajor.getContractId());
                        one.setContractCode(projectMajor.getContractCode());
                        one.setContractMny(projectMajor.getContractTaxMny());
                    }

                    if (StringUtils.isNotEmpty(sourceUnitid) ){
                        if (StringUtils.isNotEmpty(one.getSourceUnitid()) && !one.getSourceUnitid().contains(sourceUnitid)) {
                            one.setSourceUnitid(one.getSourceUnitid()+","+sourceUnitid);
                            one.setSourceUnitname(one.getSourceUnitname()+","+sourceUnitname);
                        }else if (!StringUtils.isNotEmpty(one.getSourceUnitid())){
                            one.setSourceUnitid(sourceUnitid);
                            one.setSourceUnitname(sourceUnitname);
                        }
                    }

                    systemDrwgrpService.save(one);
                    Map<String, Object> submitParam = Maps.newHashMap();
                    submitParam.put("userId", InvocationInfoProxy.getUserid());
                    submitParam.put("billtypeId", PARENT_BILL_TYPE_CODE);
                    submitParam.put("businessKey", one.getId());
                    submitParam.put("formurl", baseHost + "/settle/#/drawingEngineering/new/card?id=" + one.getId());
                    submitParam.put("procInstName", "图纸工程量管理" + one.getId() + DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
                    submitParam.put("billOrgId", one.getOrgId());
                    submitParam.put("messageType", new String[]{"sys"});
                    CommonResponse<String> stringCommonResponse = iBpmApi.doSubmit(submitParam);
                    logger.info("saveOrUpdateDcDrwgrpInfo:stringCommonResponse:"+stringCommonResponse.getMsg());
                    entity.setPid(one.getId());
                }
            }
            save(entity);
        }
        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    public SettlementCenterDrawPlanEntity handlerDate(SettlementCenterDrawPlanEntity entity){
        if (entity != null){
            List<SettlementCenterDrawPlanDetailEntity> detailList = entity.getSettlementCenterDrawPlanDetailList();

            Date planStartTime = null;//计划到图时间最早时间
            Date planEndTime = null;//计划到图时间最晚时间
            Date realStartTime = null;//实际到图时间最早时间
            Date realEndTime = null;//实际到图时间最晚时间
            boolean hasEnd = false;//有没有实际到图时间
            boolean hasnotEnd = true;//是不是全部实际到图时间都有
            for (SettlementCenterDrawPlanDetailEntity detailEntity : detailList) {
                if (detailEntity.getEndTime() != null){
                    hasEnd = true;
                }else {
                    hasnotEnd = false;
                }
                if (planStartTime == null){
                    planStartTime = detailEntity.getStartTime();
                }else {
                    if (detailEntity.getStartTime() != null && planStartTime.after(detailEntity.getStartTime())){
                        planStartTime = detailEntity.getStartTime();
                    }
                }

                if (planEndTime == null){
                    planEndTime = detailEntity.getStartTime();
                }else {
                    if (detailEntity.getStartTime() != null && planEndTime.before(detailEntity.getStartTime())){
                        planEndTime = detailEntity.getStartTime();
                    }
                }

                if (realStartTime == null){
                    realStartTime = detailEntity.getEndTime();
                }else {
                    if (detailEntity.getEndTime() != null && realStartTime.after(detailEntity.getEndTime())){
                        realStartTime = detailEntity.getEndTime();
                    }
                }

                if (realEndTime == null){
                    realEndTime = detailEntity.getEndTime();
                }else {
                    if (detailEntity.getEndTime() != null && realEndTime.before(detailEntity.getEndTime())){
                        realEndTime = detailEntity.getEndTime();
                    }
                }
            }

            if(hasEnd){
                if (realStartTime != null){
                    entity.setCalStartTime(realStartTime);
                }
            }else {
                if (planStartTime != null){
                    entity.setCalStartTime(realStartTime);
                }
            }

            Date endTime = null;
            if (hasnotEnd){
                endTime = realEndTime;
            }else {
                endTime = planEndTime;
            }

            if (endTime != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(realEndTime);
                calendar.add(Calendar.DAY_OF_MONTH, entity.getPlanFinishDays());
                entity.setCalEndTime(calendar.getTime());
            }

        }
        return entity;
    }
}
