/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.bean.SettlementCenterOutputDetailEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterOutputDetailService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"personQuantitiesInfo"})
public class PersonQuantitiesInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;
    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;
    @Autowired
    private ISettlementCenterOutputDetailService detailService;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse queryList(Long thirdNodeUserId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List list = this.infoService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).like(SettlementCenterDcDrwgrpInfoEntity::getThirdNodeUserId, (Object)thirdNodeUserId));
        BigDecimal totalOutputForYear = new BigDecimal(0);
        BigDecimal totalOutputForLastMonth = new BigDecimal(0);
        BigDecimal totalOutputForMonth = new BigDecimal(0);
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishedForLastMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForLastMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishForMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> distributedForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishedForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        HashMap<Integer, BigDecimal> outputEveryMonth = new HashMap<Integer, BigDecimal>();
        for (SettlementCenterDcDrwgrpInfoEntity entity : list) {
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                BigDecimal statisticalOutput = BigDecimal.ZERO;
                List detailEntities = this.detailService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterOutputDetailEntity::getPid, (Object)entity.getId())).eq(SettlementCenterOutputDetailEntity::getUserId, (Object)thirdNodeUserId));
                for (SettlementCenterOutputDetailEntity detailEntity : detailEntities) {
                    BigDecimal mny = detailEntity.getStatisticalOutput();
                    statisticalOutput = statisticalOutput.add(mny == null ? BigDecimal.ZERO : mny);
                }
                Date finishDate = entity.getEighthNodeTime();
                if (DateUtil.year((Date)finishDate) == DateUtil.thisYear()) {
                    totalOutputForYear = totalOutputForYear.add(statisticalOutput);
                    Integer month = DateUtil.month((Date)finishDate) + 1;
                    if (outputEveryMonth.get(month) == null) {
                        outputEveryMonth.put(month, statisticalOutput);
                    } else {
                        outputEveryMonth.put(month, ((BigDecimal)outputEveryMonth.get(month)).add(statisticalOutput));
                    }
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                    totalOutputForMonth = totalOutputForMonth.add(statisticalOutput);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                    totalOutputForLastMonth = totalOutputForLastMonth.add(statisticalOutput);
                }
            }
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                Date finishDate = null;
                finishDate = entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName()) ? entity.getEighthNodeTime() : entity.getFifthNodeTime();
                if (DateUtil.year((Date)finishDate) == DateUtil.thisYear()) {
                    finishedForYear.add(entity);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                    finishForMonth.add(entity);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                    finishedForLastMonth.add(entity);
                }
            }
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.TWO.getName())) continue;
            Date planFinishDate = entity.getDesiredTime();
            Date distributedDate = entity.getSecondNodeTime();
            if (planFinishDate != null && DateUtil.beginOfMonth((Date)planFinishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                planFinishForMonth.add(entity);
            }
            if (planFinishDate != null && DateUtil.beginOfMonth((Date)planFinishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                planFinishForLastMonth.add(entity);
            }
            if (distributedDate == null || DateUtil.year((Date)distributedDate) != DateUtil.thisYear()) continue;
            distributedForYear.add(entity);
        }
        resultMap.put("totalOutputForYear", totalOutputForYear);
        resultMap.put("totalOutputForLastMonth", totalOutputForLastMonth);
        resultMap.put("totalOutputForMonth", totalOutputForMonth);
        resultMap.put("rankYear", planFinishForMonth.size());
        resultMap.put("rankLastMonth", planFinishForMonth.size());
        resultMap.put("rankThisMonth", planFinishForMonth.size());
        int distributedCount = distributedForYear.size();
        int finishedCount = finishedForYear.size();
        String ratio = distributedCount > 0 ? finishedCount + "/" + distributedCount : "0/" + finishedCount;
        resultMap.put("yearCompletionRatio", ratio);
        int size = finishedForLastMonth.size();
        int sizeLastMonth = planFinishForLastMonth.size();
        String ratioTwo = distributedCount > 0 ? size + "/" + sizeLastMonth : "0/" + size;
        resultMap.put("lastMonthCompletionRatio", ratioTwo);
        int size2 = finishForMonth.size();
        int sizeThisMonth = planFinishForMonth.size();
        String ratioThree = distributedCount > 0 ? size2 + "/" + sizeThisMonth : "0/" + size2;
        resultMap.put("thisMonthCompletionRatio", ratioThree);
        int alertYear = 0;
        int alertLastMonth = 0;
        int alertThisMonth = 0;
        List<SettlementCenterAlertInfoEntity> result = this.alertInfoService.selectByUserId(thirdNodeUserId, null, null, null);
        for (SettlementCenterAlertInfoEntity entity : result) {
            Date time = entity.getCreateTime();
            if (DateUtil.year((Date)time) == DateUtil.thisYear()) {
                alertYear += 0;
            }
            if (DateUtil.beginOfMonth((Date)time).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                alertLastMonth += 0;
            }
            if (!DateUtil.beginOfMonth((Date)time).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) continue;
            alertThisMonth += 0;
        }
        resultMap.put("alertYear", alertYear);
        resultMap.put("alertLastMonth", alertLastMonth);
        resultMap.put("alertThisMonth", alertThisMonth);
        Object rankYear = this.infoMapper.selectRankYear(thirdNodeUserId);
        Object rankLastMonth = this.infoMapper.selectRankLastMonth(thirdNodeUserId);
        Object rankThisMonth = this.infoMapper.selectRankThisMinth(thirdNodeUserId);
        resultMap.put("rankYear", rankYear);
        resultMap.put("rankLastMonth", rankLastMonth);
        resultMap.put("rankThisMonth", rankThisMonth);
        if (planFinishForLastMonth.size() == 0) {
            resultMap.put("finishRateForLastMonth", 1);
        } else {
            resultMap.put("finishRateForLastMonth", ((double)finishedForLastMonth.size() + 0.0) / (double)planFinishForLastMonth.size());
        }
        if (planFinishForMonth.size() == 0) {
            resultMap.put("finishRateForMonth", 1);
        } else {
            resultMap.put("finishRateForMonth", ((double)finishForMonth.size() + 0.0) / (double)planFinishForMonth.size());
        }
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/queryActionMap"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, BigDecimal>>> queryActionMap(Long thirdNodeUserId, Long major) {
        List<Map<String, BigDecimal>> result = this.infoMapper.selectActionMap(thirdNodeUserId, null);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/queryPersonJobUndoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryPersonJobUndoneList(@RequestBody QueryParam param) {
        param.getParams().put("flowState", new Parameter("ne", (Object)SettleFlowStateEnum.TWO.getCode()));
        param.getParams().put("flowState", new Parameter("not_in", Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode())));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        param.getParams().put("thirdNodeUserId", new Parameter("like", (Object)InvocationInfoProxy.getUserid()));
        IPage page = this.infoService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPersonJobDoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryPersonJobDoneList(@RequestBody QueryParam param) {
        param.getParams().put("flowState", new Parameter("sql", (Object)"(flow_state = 9 or flow_state = 2)"));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        param.getParams().put("thirdNodeUserId", new Parameter("like", (Object)InvocationInfoProxy.getUserid()));
        IPage page = this.infoService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExportUndone"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportUndone(HttpServletResponse response, @RequestBody QueryParam param) {
        HashMap<String, List> beans = new HashMap<String, List>();
        param.getParams().put("flowState", new Parameter("not_in", Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode())));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        param.getParams().put("thirdNodeUserId", new Parameter("like", (Object)InvocationInfoProxy.getUserid()));
        List list = this.infoService.queryList(param);
        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportDone"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDone(HttpServletResponse response, @RequestBody QueryParam param) {
        HashMap<String, List> beans = new HashMap<String, List>();
        param.getParams().put("flowState", new Parameter("sql", (Object)"(flow_state = 9 or flow_state = 2)"));
        param.getParams().put("eighth_node_time", new Parameter("sql", (Object)"((eighth_node_time >= CONCAT(YEAR(CURRENT_DATE), '-01-01 00:00:00')          AND eighth_node_time <= CONCAT(YEAR(CURRENT_DATE), '-12-31 23:59:59')) or eighth_node_time is null)"));
        param.getParams().put("thirdNodeUserId", new Parameter("like", (Object)InvocationInfoProxy.getUserid()));
        List list = this.infoService.queryList(param);
        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }
}

