package com.ejianc.foundation.share.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 价格库参数设置
 * 
 * @author generator
 * 
 */
public class PriceDepotParamSetVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Integer priceDepotType; // 材料价格库
    private String priceDepotTypeName; // 材料价格库名称 1:材料价格库 2:周转材价格库 3:设备采购价格库  4:设备租赁价格库 5: 劳务分包价格库 6:专业分包价格库
    private String categoryId; // 类别id
    private String categoryName; // 类别名称
    private Integer source; // 来源 1：合同 2:结算
    private String sourceName; // 来源名称  1：合同 2:结算 3:结算
    private BigDecimal cycle; // 查询周期 / 近X个月
    private Integer sequence; // 排序
    private Long parentId; // parent_id
    private Boolean leafFlag; // 是否末级
    private String tid;
    private String tpid;
    private List<ITreeNodeB> children;
    private List<Long> materialTypeIdList;
    private Integer priorityFlag; // 优先级  1-历史价格库 2-指导价
    private String priorityFlagName; // 优先级  1-历史价格库 2-指导价

    public String getPriorityFlagName() {
        return priorityFlagName;
    }

    public void setPriorityFlagName(String priorityFlagName) {
        this.priorityFlagName = priorityFlagName;
    }

    public Integer getPriorityFlag() {
        return priorityFlag;
    }

    public void setPriorityFlag(Integer priorityFlag) {
        this.priorityFlag = priorityFlag;
    }
    public Integer getPriceDepotType() {
        return priceDepotType;
    }

    public void setPriceDepotType(Integer priceDepotType) {
        this.priceDepotType = priceDepotType;
    }
    public String getPriceDepotTypeName() {
        return priceDepotTypeName;
    }

    public void setPriceDepotTypeName(String priceDepotTypeName) {
        this.priceDepotTypeName = priceDepotTypeName;
    }
    @ReferSerialTransfer(referCode="MaterialCategory001,ProsubCategory001,LabsubCategory001")
    public String getCategoryId() {
        return categoryId;
    }
    @ReferDeserialTransfer
    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public BigDecimal getCycle() {
        return cycle;
    }

    public void setCycle(BigDecimal cycle) {
        this.cycle = cycle;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }



    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public List<Long> getMaterialTypeIdList() {
        return materialTypeIdList;
    }

    public void setMaterialTypeIdList(List<Long> materialTypeIdList) {
        this.materialTypeIdList = materialTypeIdList;
    }
}
