/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/customer/category/"})
public class CustomerCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CUSTOMER_CATEGORY_BILL_CODE = "SUPPORT_CUSTOMER_CATEGORY";
    @Autowired
    private ICustomerCategoryService customerCategoryService;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${insideCustomerCategoryCode:CC-inside}")
    private String insideCustomerCategoryCode;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody CustomerCategoryVO customerCategoryVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (customerCategoryVo.getId() != null && customerCategoryVo.getId() > 0L) {
            CustomerCategoryEntity uniqueBean = this.customerCategoryService.queryDetail(customerCategoryVo.getId());
            uniqueBean.setCode(customerCategoryVo.getCode());
            uniqueBean.setName(customerCategoryVo.getName());
            uniqueBean.setSequence(customerCategoryVo.getSequence());
            uniqueBean.setDescription(customerCategoryVo.getDescription());
            this.customerCategoryService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(CUSTOMER_CATEGORY_BILL_CODE, tenantId);
        if (codeBatchByRuleCode.isSuccess()) {
            customerCategoryVo.setCode((String)codeBatchByRuleCode.getData());
        }
        CustomerCategoryEntity customerCategoryEntity = (CustomerCategoryEntity)((Object)BeanMapper.map((Object)((Object)customerCategoryVo), CustomerCategoryEntity.class));
        customerCategoryEntity.setId(IdWorker.getId());
        if (customerCategoryEntity.getParentId() != null && customerCategoryEntity.getParentId() > 0L) {
            CustomerCategoryEntity uniqueBean = this.customerCategoryService.queryDetail(customerCategoryEntity.getParentId());
            customerCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + customerCategoryEntity.getId());
        } else {
            customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
        }
        this.customerCategoryService.saveOrUpdate((Object)customerCategoryEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CustomerCategoryVO> queryDetail(@RequestParam Long id) {
        CustomerCategoryEntity entity = this.customerCategoryService.queryDetail(id);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), CustomerCategoryVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<CustomerCategoryVO> children = this.customerCategoryService.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u6709\u5b50\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<CustomerVO> customerList = this.customerService.queryListByCategoryId(id);
        if (customerList != null && customerList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u5df2\u6709\u5ba2\u6237\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.customerCategoryService.delete(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        List dataList = this.customerCategoryService.queryList(queryParam, false);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryRefTree(@RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        queryParam.getParams().put("code", new Parameter("ne", (Object)this.insideCustomerCategoryCode));
        queryParam.getOrderMap().put("sequence", "asc");
        List dataList = this.customerCategoryService.queryList(queryParam, false);
        if (ListUtil.isEmpty((List)dataList)) {
            return new ArrayList<Map<String, Object>>();
        }
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"customer-category-import.xlsx", (String)"\u5ba2\u6237\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<CustomerCategoryEntity> list = new ArrayList<CustomerCategoryEntity>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                CustomerCategoryVO customerCategoryVO = new CustomerCategoryVO();
                CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(CUSTOMER_CATEGORY_BILL_CODE, tenantId);
                if (codeBatchByRuleCode.isSuccess()) {
                    customerCategoryVO.setCode((String)codeBatchByRuleCode.getData());
                } else {
                    customerCategoryVO.setCode(String.valueOf(new Date().getTime()));
                }
                if (StringUtils.isNotEmpty((CharSequence)datas.get(0))) {
                    String name = datas.get(0).toString();
                    CustomerCategoryVO vo = this.customerCategoryService.queryByName(name);
                    customerCategoryVO.setParentId(vo.getId());
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(1))) {
                    errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5ba2\u6237\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    continue;
                }
                customerCategoryVO.setName(datas.get(1).toString());
                customerCategoryVO.setDescription(datas.get(2).toString());
                if (StringUtils.isNotEmpty((CharSequence)datas.get(3).toString())) {
                    Pattern pattern = Pattern.compile("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
                    Matcher isNum = pattern.matcher(datas.get(3).toString());
                    if (!isNum.matches()) {
                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6392\u5e8f\u53f7\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                        continue;
                    }
                    customerCategoryVO.setDescription(datas.get(3).toString());
                }
                CustomerCategoryEntity customerCategoryEntity = (CustomerCategoryEntity)((Object)BeanMapper.map((Object)((Object)customerCategoryVO), CustomerCategoryEntity.class));
                customerCategoryEntity.setId(IdWorker.getId());
                if (customerCategoryEntity.getParentId() != null && customerCategoryEntity.getParentId() > 0L) {
                    CustomerCategoryEntity uniqueBean = this.customerCategoryService.queryDetail(customerCategoryEntity.getParentId());
                    customerCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + customerCategoryEntity.getId());
                } else {
                    customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
                }
                list.add(customerCategoryEntity);
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        this.customerCategoryService.saveOrUpdateBatch(list, list.size());
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }
}

