/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectSetExPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetExPoolService;
import com.ejianc.foundation.share.vo.ProjectSetExPoolVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectExApi/"})
public class ProjectSetExApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetExPoolService projectSetExPoolService;
    @Autowired
    private IOrgApi iOrgApi;

    @PostMapping(value={"pushProject"})
    public CommonResponse<String> pushProject(@RequestBody List<ProjectSetExPoolVO> projects) {
        if (ListUtil.isEmpty(projects)) {
            return CommonResponse.success((String)"\u63a8\u9001\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        this.logger.info("\u90d1\u5dde\u4e00\u5efa\u9879\u76ee pushProject---{}", (Object)JSONObject.toJSONString(projects));
        QueryParam param = new QueryParam();
        for (ProjectSetExPoolVO project : projects) {
            ProjectSetExPoolEntity entity;
            if (!StringUtils.isNotEmpty((CharSequence)project.getCode())) continue;
            param.getParams().put("code", new Parameter("eq", (Object)project.getCode()));
            List exPoolEntities = this.projectSetExPoolService.queryList(param);
            if (ListUtil.isNotEmpty((List)exPoolEntities)) {
                entity = (ProjectSetExPoolEntity)((Object)exPoolEntities.get(0));
                Long id = entity.getId();
                Integer version = entity.getVersion();
                entity = (ProjectSetExPoolEntity)((Object)BeanMapper.map((Object)((Object)project), ProjectSetExPoolEntity.class));
                entity.setId(id);
                entity.setVersion(version);
                this.projectSetExPoolService.saveOrUpdateNoES((Object)entity);
                continue;
            }
            entity = (ProjectSetExPoolEntity)((Object)BeanMapper.map((Object)((Object)project), ProjectSetExPoolEntity.class));
            this.projectSetExPoolService.saveOrUpdateNoES((Object)entity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectSetExPoolVO>> refProjectSetData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)condition) && StringUtils.isNotBlank((CharSequence)(_con = JSONObject.parseObject((String)condition)).getString("orgId"))) {
            orgId = _con.getLong("orgId");
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page(1L, (long)param.getPageSize(), 0L));
        }
        IPage page = this.projectSetExPoolService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectSetExPoolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

