/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.EquipmentMapper;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EquipmentServiceImpl
implements IEquipmentService {
    @Autowired
    private EquipmentMapper equipmentMapper;
    @Autowired
    private EquipmentCategoryMapper equipmentCategoryMapper;

    @Override
    public List<EquipmentVO> queryListByCategoryId(Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentEntity> entities = this.equipmentMapper.queryListByCategoryId(tenantId, categoryId);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, EquipmentVO.class);
        }
        return null;
    }

    @Override
    public List<EquipmentVO> queryItem(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentEntity> equipmentEntities = this.equipmentMapper.queryItem(tenantId, ids);
        if (equipmentEntities != null && equipmentEntities.size() > 0) {
            return BeanMapper.mapList(equipmentEntities, EquipmentVO.class);
        }
        return null;
    }

    @Override
    public EquipmentVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        EquipmentEntity entity = this.equipmentMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (EquipmentVO)BeanMapper.map((Object)entity, EquipmentVO.class);
        }
        return null;
    }

    @Override
    public void update(EquipmentVO uniqueBean) {
        this.equipmentMapper.update(uniqueBean);
    }

    @Override
    public void amend(Long id, Long property, String propertyName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.equipmentMapper.amend(id, property, propertyName, tenantId);
    }

    @Override
    public void save(EquipmentVO EquipmentVo) {
        this.equipmentMapper.save(EquipmentVo);
    }

    @Override
    public void insertBatch(List<EquipmentVO> materialVOList) {
        if (ListUtil.isNotEmpty(materialVOList)) {
            ArrayList<EquipmentVO> toInsert = new ArrayList<EquipmentVO>();
            for (EquipmentVO equipmentVO : materialVOList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.equipmentMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(equipmentVO);
            }
            if (toInsert.size() > 0) {
                this.equipmentMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.equipmentMapper.delete(tenantId, id);
        }
    }

    @Override
    public IPage<EquipmentEntity> queryPage(QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                EquipmentCategoryEntity categoryEntity;
                Object value;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (value = parameter.getValue()) == null || (categoryEntity = this.equipmentCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<EquipmentEntity> records = this.equipmentMapper.queryList(condition);
        Long count = this.equipmentMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public EquipmentVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        EquipmentVO EquipmentVo = this.equipmentMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
        return EquipmentVo;
    }

    @Override
    public EquipmentVO queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.equipmentMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<EquipmentEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<EquipmentEntity> records = this.equipmentMapper.queryExportList(condition);
        return records;
    }

    @Override
    public void insertEquipmentListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.equipmentMapper.insertEquipmentListFromPlatform(tenantId);
    }

    @Override
    public IPage<EquipmentEntity> queryRefEquipmentPage(Map<String, Object> params) {
        List<EquipmentEntity> dataList = this.equipmentMapper.queryRefEquipmentList(params);
        Long dataCount = this.equipmentMapper.queryRefEquipmentCount(params);
        Page page = new Page();
        page.setCurrent(Long.valueOf(params.get("pageNumber").toString()).longValue());
        page.setSize(Long.valueOf(params.get("pageSize").toString()).longValue());
        page.setRecords(dataList);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = this.equipmentMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
        return CommonResponse.success();
    }

    @Override
    public List<EquipmentVO> queryEquipmentListByCodes(List<String> codeList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("codeList", codeList);
        List<EquipmentEntity> equipmentEntities = this.equipmentMapper.queryEquipmentListByCodes(params);
        if (equipmentEntities != null && equipmentEntities.size() > 0) {
            return BeanMapper.mapList(equipmentEntities, EquipmentVO.class);
        }
        return null;
    }
}

