/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.mapper.LabsubItemMapper;
import com.ejianc.foundation.share.mapper.ProsubItemMapper;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.LabsubItemImportVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="labsubItemService")
public class LabsubItemServiceImpl
extends BaseServiceImpl<LabsubItemMapper, LabsubItemEntity>
implements ILabsubItemService {
    @Autowired
    private ILabsubItemService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private LabsubItemMapper labsubItemMapper;
    @Autowired
    private ProsubItemMapper prosubItemMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "LSI_CODE";
    private final String PLANT_CODE = "P-su39U70181";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ILabsubCategoryService labsubCategoryService;
    @Autowired
    private ISubjectOrgService subjectOrgService;

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        int i = this.labsubItemMapper.updateByCategoryId(categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<LabsubItemImportVO> successList = new ArrayList<LabsubItemImportVO>();
        ArrayList<LabsubItemImportVO> errorList = new ArrayList<LabsubItemImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u52b3\u52a1\u5206\u5305\u6863\u6848\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap caListMap = new HashMap();
            HashMap materialMap = new HashMap();
            HashMap<String, ProsubItemVO> materialBeanMap = new HashMap<String, ProsubItemVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                LabsubItemImportVO prosubItemImport = new LabsubItemImportVO();
                prosubItemImport.setId(IdWorker.getId());
                prosubItemImport.setCategoryCode((String)datas.get(0));
                prosubItemImport.setTrawlingCode((String)datas.get(1));
                prosubItemImport.setTrawlingName((String)datas.get(2));
                prosubItemImport.setPriceType((String)datas.get(3));
                prosubItemImport.setUnitName((String)datas.get(4));
                prosubItemImport.setJobContent((String)datas.get(5));
                prosubItemImport.setDetailMeasurementRules((String)datas.get(6));
                prosubItemImport.setRemarks((String)datas.get(7));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    prosubItemImport.setRemarks("\u6863\u6848\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    prosubItemImport.setRemarks("\u6863\u6848\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    prosubItemImport.setRemarks("\u4ef7\u683c\u7c7b\u578b\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                List materialCategoryVo = (List)caListMap.get(datas.get(0));
                if (ListUtil.isEmpty((List)materialCategoryVo)) {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)String.valueOf(datas.get(0))));
                    materialCategoryVo = this.labsubCategoryService.queryList(queryParam, false);
                    if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                        caListMap.put(datas.get(0), materialCategoryVo);
                    }
                }
                if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                    List list;
                    LabsubItemEntity one;
                    QueryWrapper queryWrapper;
                    prosubItemImport.setCategoryId(((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                    prosubItemImport.setCategoryName(((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getCategoryName());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            prosubItemImport.setTrawlingCode((String)codeBatchByRuleCode.getData());
                        } else {
                            prosubItemImport.setTrawlingCode(System.currentTimeMillis() + "");
                        }
                    } else {
                        ProsubItemVO vo = (ProsubItemVO)((Object)materialMap.get(datas.get(1)));
                        if (vo == null) {
                            queryWrapper = new QueryWrapper();
                            queryWrapper.eq((Object)"trawling_code", (Object)String.valueOf(datas.get(1)));
                            one = null;
                            list = this.service.list((Wrapper)queryWrapper);
                            if (CollectionUtils.isNotEmpty((Collection)list)) {
                                one = (LabsubItemEntity)((Object)list.get(0));
                            }
                            if (one != null) {
                                vo = (ProsubItemVO)((Object)BeanMapper.map((Object)((Object)one), ProsubItemVO.class));
                            }
                            if (vo != null) {
                                materialMap.put(datas.get(1), vo);
                            }
                        }
                        if (vo != null) {
                            prosubItemImport.setRemarks("\u6863\u6848\u7f16\u53f7\u91cd\u590d\uff01");
                            errorList.add(prosubItemImport);
                            continue;
                        }
                    }
                    ProsubItemVO materialBean = (ProsubItemVO)((Object)materialBeanMap.get(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + ((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId()));
                    if (materialBean == null) {
                        queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"trawling_name", (Object)prosubItemImport.getTrawlingName());
                        queryWrapper.eq((Object)"price_type", (Object)prosubItemImport.getPriceType());
                        queryWrapper.eq((Object)"unit_name", (Object)prosubItemImport.getUnitName());
                        queryWrapper.eq((Object)"category_id", (Object)((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                        one = null;
                        list = this.service.list((Wrapper)queryWrapper);
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            one = (LabsubItemEntity)((Object)list.get(0));
                        }
                        if (one != null) {
                            materialBean = (ProsubItemVO)((Object)BeanMapper.map((Object)((Object)one), ProsubItemVO.class));
                            materialBeanMap.put(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + ((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId(), materialBean);
                        }
                    }
                    if (materialBean != null) {
                        prosubItemImport.setRemarks("\u91cd\u590d\u6863\u6848\uff01");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    prosubItemImport.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    prosubItemImport.setCreateTime(new Date());
                    prosubItemImport.setTenantId(InvocationInfoProxy.getTenantid());
                    prosubItemImport.setEnabled(1);
                    successList.add(prosubItemImport);
                } else {
                    prosubItemImport.setRemarks("\u6863\u6848\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                    errorList.add(prosubItemImport);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8)))) continue;
                String subjectName = ((String)datas.get(8)).toString();
                QueryWrapper subjectQueryWrapper = new QueryWrapper();
                subjectQueryWrapper.like((Object)"subject_name", (Object)subjectName);
                List list = this.subjectOrgService.list((Wrapper)subjectQueryWrapper);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                prosubItemImport.setSubjectId(((SubjectOrgEntity)((Object)list.get(0))).getId());
                prosubItemImport.setSubjectName(((SubjectOrgEntity)((Object)list.get(0))).getSubjectName());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<LabsubItemVO> saveOrUpdateLabsubItem(LabsubItemVO saveorUpdateVO) {
        LabsubItemEntity entity = (LabsubItemEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), LabsubItemEntity.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("trawlingCode", new Parameter("eq", (Object)saveorUpdateVO.getTrawlingCode()));
        List labsubItemEntities = this.service.queryList(queryParam);
        if (saveorUpdateVO.getId() != null) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getTrawlingCode())) {
                return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            LabsubItemEntity labsubItemEntity = (LabsubItemEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            if (!labsubItemEntity.getTrawlingCode().equals(saveorUpdateVO.getTrawlingCode()) && CollectionUtils.isNotEmpty((Collection)labsubItemEntities)) {
                return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else if (CollectionUtils.isNotEmpty((Collection)labsubItemEntities)) {
            return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                if (null == entity.getSubjectId()) {
                    Long categoryId = entity.getCategoryId();
                    LabsubCategoryEntity labsubCategoryEntity = (LabsubCategoryEntity)((Object)this.labsubCategoryService.selectById(categoryId));
                    entity.setSubjectId(labsubCategoryEntity.getSubjectId());
                    entity.setSubjectName(labsubCategoryEntity.getSubjectName());
                }
                if (saveorUpdateVO.getTrawlingCode() == null) {
                    entity.setTrawlingCode((String)billCode.getData());
                }
                entity.setEnabled(0);
                entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
                entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
                LabsubCategoryEntity labsubCategoryEntity = (LabsubCategoryEntity)((Object)this.labsubCategoryService.selectById(entity.getCategoryId()));
                if (labsubCategoryEntity != null) {
                    entity.setCategoryName(labsubCategoryEntity.getCategoryName());
                }
            }
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            updateWrapper.set(LabsubItemEntity::getTrawlingName, (Object)saveorUpdateVO.getTrawlingName());
            updateWrapper.set(LabsubItemEntity::getPriceType, (Object)saveorUpdateVO.getPriceType());
            updateWrapper.set(LabsubItemEntity::getUnitName, (Object)saveorUpdateVO.getUnitName());
            updateWrapper.set(LabsubItemEntity::getJobContent, (Object)saveorUpdateVO.getJobContent());
            updateWrapper.set(LabsubItemEntity::getOrgId, (Object)this.sessionManager.getUserContext().getOrgId());
            updateWrapper.set(LabsubItemEntity::getOrgName, (Object)this.sessionManager.getUserContext().getOrgName());
            updateWrapper.set(LabsubItemEntity::getSubjectId, (Object)saveorUpdateVO.getSubjectId());
            updateWrapper.set(LabsubItemEntity::getTrawlingCode, (Object)saveorUpdateVO.getTrawlingCode());
            updateWrapper.set(LabsubItemEntity::getSubjectName, (Object)saveorUpdateVO.getSubjectName());
            updateWrapper.set(LabsubItemEntity::getRemarks, (Object)saveorUpdateVO.getRemarks());
            updateWrapper.set(LabsubItemEntity::getDetailMeasurementRules, (Object)saveorUpdateVO.getDetailMeasurementRules());
            updateWrapper.set(BaseEntity::getUpdateTime, (Object)new Date());
            updateWrapper.set(BaseEntity::getUpdateUserCode, (Object)InvocationInfoProxy.getUsercode());
            this.service.update((Wrapper)updateWrapper);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        LabsubItemVO vo = (LabsubItemVO)((Object)BeanMapper.map((Object)((Object)entity), LabsubItemVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public List<LabsubItemVO> queryLabsubItemList(Page<LabsubItemVO> page, QueryWrapper wrapper) {
        return ((LabsubItemMapper)this.baseMapper).queryProsubItemList(page, wrapper);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, ids);
        updateWrapper.set(LabsubItemEntity::getSubjectId, (Object)subjectId);
        updateWrapper.set(LabsubItemEntity::getSubjectName, (Object)subjectName);
        this.service.update((Wrapper)updateWrapper);
    }

    @Override
    public CommonResponse<List<Map<String, Object>>> queryWholeTreeItemsById(String idStr, String type) {
        List<Long> idList = Arrays.stream(idStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
        this.logger.info("LabsubItemServiceImpl***queryWholeTreeItemsById()\u65b9\u6cd5***begin***param\uff1aid={}\uff0ctype={}", (Object)idStr, (Object)type);
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map<String, Object>> itemMapList = "lab".equals(type) ? this.labsubItemMapper.queryLabItemListByIds(idList, tenantId) : this.prosubItemMapper.queryProItemListByIds(idList, tenantId);
        if (CollectionUtils.isEmpty(itemMapList)) {
            this.logger.error("\u67e5\u8be2\u4e0d\u5230\u6863\u6848\u6570\u636e\uff0cparam\uff1aids={}\uff0ctype={}", (Object)idStr, (Object)type);
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u6863\u6848\u6570\u636e");
        }
        Boolean queryCategoryFlag = false;
        CommonResponse response = this.paramConfigApi.getByCode("P-su39U70181");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u7f16\u7801-{}\uff0c\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff08\u6863\u6848\u6765\u6e90\u6570\u636e\u662f\u5426\u67e5\u8be2\u7236\u7ea7\u5206\u7c7b\uff09\u914d\u7f6e\u4fe1\u606f\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)"P-su39U70181", (Object)response.getMsg());
            queryCategoryFlag = true;
        } else if ("1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
            queryCategoryFlag = true;
        }
        List<Object> categoryMapList = new ArrayList();
        if (queryCategoryFlag.booleanValue()) {
            ArrayList<Long> categoryIdList = new ArrayList();
            for (Map<String, Object> itemMap2 : itemMapList) {
                String innerCode = itemMap2.get("innerCode").toString();
                if (StringUtils.isBlank((CharSequence)innerCode)) {
                    this.logger.error("\u67e5\u8be2\u5230\u7684innerCode\u4e3a\u7a7a\uff0cparam\uff1aids={}\uff0ctype={}", (Object)idStr, (Object)type);
                    return CommonResponse.error((String)"\u67e5\u8be2\u5230\u7684innerCode\u4e3a\u7a7a");
                }
                List categoryIds = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).collect(Collectors.toList());
                categoryIdList.addAll(categoryIds);
            }
            categoryIdList = categoryIdList.stream().distinct().collect(Collectors.toList());
            categoryMapList = "lab".equals(type) ? this.labsubItemMapper.queryLabCategoryListByCategoryIds(categoryIdList, tenantId) : this.prosubItemMapper.queryProCategoryListByCategoryIds(categoryIdList, tenantId);
            if (CollectionUtils.isEmpty(categoryMapList) && categoryIdList.size() > 1) {
                this.logger.error("\u67e5\u8be2\u4e0d\u5230\u5206\u7c7b\u6570\u636e");
                return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u5206\u7c7b\u6570\u636e");
            }
            categoryMapList = categoryMapList.stream().distinct().collect(Collectors.toList());
            categoryMapList.forEach(categoryMap -> {
                categoryMap.put("flag", "1");
                categoryMap.put("docId", null);
                categoryMap.put("id", categoryMap.get("category_id"));
            });
        }
        itemMapList = itemMapList.stream().distinct().collect(Collectors.toList());
        itemMapList.forEach(itemMap -> {
            itemMap.put("docId", Long.parseLong(itemMap.get("id").toString()));
            itemMap.put("flag", "2");
            itemMap.put("category_id", itemMap.get("parentId"));
        });
        ArrayList distinctList = new ArrayList();
        distinctList.addAll(categoryMapList);
        distinctList.addAll(itemMapList);
        ArrayList resList = new ArrayList();
        for (Map en : distinctList) {
            if (MapUtils.isEmpty((Map)en)) continue;
            HashMap map = new HashMap();
            map.put("flag", en.get("flag"));
            map.put("detailName", en.get("trawling_name"));
            map.put("unitName", en.get("unit_name"));
            map.put("detailUnit", en.get("unit_name"));
            map.put("priceType", en.get("price_type"));
            map.put("jobContent", en.get("job_content"));
            map.put("detailMeasurementRules", en.get("detail_measurement_rules"));
            map.put("id", en.get("id"));
            map.put("detailCode", en.get("trawling_code"));
            map.put("remarks", en.get("remarks"));
            map.put("parentId", en.get("parentId"));
            map.put("categoryId", en.get("category_id"));
            map.put("docId", en.get("docId"));
            map.put("unitId", null);
            resList.add(map);
        }
        this.logger.info("LabsubItemServiceImpl***queryWholeTreeItemsById()\u65b9\u6cd5***end***\u67e5\u8be2\u6863\u6848\u6570\u636e\u6210\u529f\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(resList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((String)"\u67e5\u8be2\u6863\u6848\u6570\u636e\u6210\u529f", resList);
    }
}

