/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.controller.SupplierController;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.SupplyBankVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bankAccount"})
public class BankAccountController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_TYPE_CODE = "BT211028000000001";
    @Autowired
    private IBankAccountService service;
    @Autowired
    private SupplierController supplierController;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BankAccountVO> saveOrUpdate(@RequestBody BankAccountVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() != null) {
            CommonResponse res = this.billTypeApi.checkQuote(BILL_TYPE_CODE, saveorUpdateVO.getId());
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()) {
                throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237\u3010" + saveorUpdateVO.getBankCode() + "\u3011\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
            }
        }
        BankAccountVO vo = this.service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankAccountVO> queryDetail(Long id) {
        BankAccountEntity entity = (BankAccountEntity)((Object)this.service.selectById(id));
        BankAccountVO vo = (BankAccountVO)((Object)BeanMapper.map((Object)((Object)entity), BankAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BankAccountVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        return CommonResponse.success((String)this.service.delete(ids));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BankAccountVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankNum");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankNum");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("supplierName");
        Map params = param.getParams();
        params.put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List dataList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)dataList, BankAccountVO.class);
        list.forEach(vo -> vo.setEnabledName(NumberUtils.INTEGER_ONE.equals(vo.getEnabled()) ? "\u5df2\u542f\u7528" : "\u5df2\u505c\u7528"));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        if (params.containsKey("supplierFlag") && ((Parameter)params.get("supplierFlag")).getValue().equals("1,3")) {
            ExcelExport.getInstance().export("bank-account-supplier-export.xlsx", beans, response);
        } else if (params.containsKey("supplierFlag") && ((Parameter)params.get("supplierFlag")).getValue().equals("2,3")) {
            ExcelExport.getInstance().export("bank-account-customer-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("bank-account-inside-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refBankAccountData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BankAccountVO>> refBankAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("memo");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"accType")) {
                if (_con.get((Object)"accType").toString().contains("gys")) {
                    param.getParams().put("supplierFlag", new Parameter("in", Arrays.asList(1, 3)));
                    param.getParams().put("insideState", new Parameter("eq", (Object)0));
                } else if (_con.get((Object)"accType").toString().contains("kh")) {
                    param.getParams().put("supplierFlag", new Parameter("in", Arrays.asList(2, 3)));
                    param.getParams().put("insideState", new Parameter("eq", (Object)0));
                } else {
                    param.getParams().put("insideState", new Parameter("eq", (Object)1));
                }
            }
            if (_con.containsKey((Object)"supplierId") && _con.get((Object)"supplierId") != null) {
                param.getParams().put("supplierId", new Parameter("eq", (Object)Long.valueOf(_con.get((Object)"supplierId").toString())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/enabled"})
    public CommonResponse<String> enabled(@RequestBody List<BankAccountVO> vos) {
        return CommonResponse.success((String)this.service.enabled(vos));
    }

    @PostMapping(value={"/defaultFlag"})
    public CommonResponse<String> defaultFlag(@RequestBody BankAccountVO vo) {
        return CommonResponse.success((String)this.service.defaultFlag(vo));
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"bank-account-import.xlsx", (String)"\u94f6\u884c\u8d26\u6237\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/customerDownload"})
    @ResponseBody
    public void customerDownload(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"bank-account-customer-import.xlsx", (String)"\u5ba2\u6237\u94f6\u884c\u8d26\u6237\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/supplierDownload"})
    @ResponseBody
    public void supplierDownload(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"bank-account-supplier-import.xlsx", (String)"\u4f9b\u5e94\u5546\u94f6\u884c\u8d26\u6237\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<BankAccountVO> importVOS) {
        return CommonResponse.success((String)this.service.saveImportExcel(request, importVOS));
    }

    @RequestMapping(value={"/getBankAccountByAccTypeAndId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankAccountVO> getBankAccountByAccTypeAndId(Long id, String accType) {
        if (id == null || StringUtils.isEmpty((CharSequence)accType)) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546/\u5ba2\u6237/\u5185\u90e8\u5355\u4f4did\u6216\u8005\u8d26\u6237\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"supplier_id", (Object)id);
        wrapper.eq((Object)"enabled", (Object)1);
        wrapper.orderByDesc((Object)"default_flag");
        List list = this.service.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u94f6\u884c\u8d26\u6237\u4fe1\u606f\uff01");
        }
        BankAccountVO vo = (BankAccountVO)((Object)BeanMapper.map(list.get(0), BankAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/saveOrUpdateBankInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdateBankInfo(@RequestBody SupplierVO supplierVo) {
        List<BankAccountVO> banks = supplierVo.getBanks();
        if (banks.size() > 0) {
            for (BankAccountVO bankAccountVO : banks) {
                if (bankAccountVO.getEnabled() != 1) continue;
                SupplyBankVO supplyBankVO = new SupplyBankVO();
                supplyBankVO.setId(bankAccountVO.getOrgId());
                supplyBankVO.setPid(bankAccountVO.getSupplierId());
                supplyBankVO.setDefaultable(bankAccountVO.getDefaultFlag());
                supplyBankVO.setBankId(bankAccountVO.getBankId());
                supplyBankVO.setBankName(bankAccountVO.getBankName());
                supplyBankVO.setBankCode(bankAccountVO.getBankCode());
                supplyBankVO.setBankAccount(bankAccountVO.getBankAccount());
                supplyBankVO.setBankNum(bankAccountVO.getBankNum());
                supplyBankVO.setAddress(bankAccountVO.getBankAddress());
                supplyBankVO.setCategoryId(bankAccountVO.getCategoryId());
                supplyBankVO.setCategoryName(bankAccountVO.getCategoryName());
                this.supplierController.saveOrUpdateBank(supplyBankVO);
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u6210\u529f\uff01", (Object)((Object)supplierVo));
    }

    @RequestMapping(value={"/deleteByIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteByIds(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

