/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bankCategory"})
public class BankCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SUPPORT_BANK_CATEGORY_CODE";
    @Autowired
    private IBankCategoryService service;
    @Autowired
    private IBankService bankService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BankCategoryVO> saveOrUpdate(@RequestBody BankCategoryVO saveorUpdateVO) {
        BankCategoryEntity entity = (BankCategoryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), BankCategoryEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isBlank((CharSequence)entity.getCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getCode())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"code", (Object)entity.getCode());
            queryWrapper.ne(entity.getId() != null, (Object)"id", (Object)entity.getId());
            int count = this.service.count((Wrapper)queryWrapper);
            if (count > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u94f6\u884c\u7c7b\u522b\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (saveorUpdateVO.getId() != null) {
            this.bankService.updateCategoryNameByCategoryId(saveorUpdateVO.getId(), saveorUpdateVO.getName());
        }
        BankCategoryVO vo = (BankCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), BankCategoryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankCategoryVO> queryDetail(Long id) {
        BankCategoryEntity entity = (BankCategoryEntity)((Object)this.service.selectById(id));
        BankCategoryVO vo = (BankCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), BankCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(BankEntity::getBankCategoryId, ids);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List entities = this.bankService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff01\u8be5\u94f6\u884c\u7c7b\u522b\u5df2\u5b58\u5728\u94f6\u884c\u6863\u6848\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.service.removeByIds(ids, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BankCategoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refBankCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BankCategoryEntity> refBankCategoryData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        if (InvocationInfoProxy.getTenantid() != null) {
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        } else {
            param.getParams().put("tenantId", new Parameter("eq", (Object)"999999"));
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        param.getOrderMap().put("code", "asc");
        List dataList = this.service.queryList(param, false);
        if (ListUtil.isEmpty((List)dataList)) {
            return new ArrayList<BankCategoryEntity>();
        }
        return dataList;
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"bankCategory-export.xlsx", (String)"\u94f6\u884c\u6863\u6848\u5206\u7c7b\u5bfc\u51fa\u6a21\u677f");
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<BankCategoryVO> importVOS) {
        return CommonResponse.success((String)this.service.saveImportExcel(request, importVOS));
    }
}

