/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller.api;

import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareSupplierWebApi/"})
public class SupplierWebApi {
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IBankService bankService;

    @GetMapping(value={"querySupplierList"})
    CommonResponse<List<SupplierVO>> querySupplierList() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.supplierService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, SupplierVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
    }

    @GetMapping(value={"queryBankAccountList"})
    CommonResponse<List<BankAccountVO>> queryBankAccountList() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.bankAccountService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, BankAccountVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
    }

    @GetMapping(value={"queryBankList"})
    CommonResponse<List<BankVO>> queryBankList() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.bankService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, BankVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
    }

    @GetMapping(value={"queryBankAccountByCustomerId"})
    CommonResponse<BankAccountVO> queryBankAccountByCustomerId(@RequestParam(value="customerId") Long customerId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("customer_id", new Parameter("eq", (Object)customerId));
        queryParam.getParams().put("default_flag", new Parameter("eq", (Object)1));
        List list = this.bankAccountService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", BeanMapper.mapList((Iterable)list, BankAccountVO.class).get(0));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((Object)new BankAccountVO()));
    }

    @GetMapping(value={"queryDefaultBankAccountById"})
    CommonResponse<BankAccountVO> queryDefaultBankAccountById(@RequestParam(value="id") Long id, @RequestParam(value="type") String type) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if ("supplierId".equals(type)) {
            queryParam.getParams().put("supplierId", new Parameter("eq", (Object)id));
        } else if ("customerId".equals(type)) {
            queryParam.getParams().put("customerId", new Parameter("eq", (Object)id));
        } else if ("insideOrgId".equals(type)) {
            queryParam.getParams().put("insideOrgId", new Parameter("eq", (Object)id));
        } else {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        queryParam.getParams().put("defaultFlag", new Parameter("eq", (Object)1));
        List list = this.bankAccountService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", BeanMapper.mapList((Iterable)list, BankAccountVO.class).get(0));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((Object)new BankAccountVO()));
    }
}

