/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.mapper.BankCategoryMapper;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.vo.BankCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="bankCategoryService")
public class BankCategoryServiceImpl
extends BaseServiceImpl<BankCategoryMapper, BankCategoryEntity>
implements IBankCategoryService {
    @Autowired
    private BankCategoryMapper bankCategoryMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SUPPORT_BANK_CATEGORY_CODE";

    @Override
    public List<BankCategoryEntity> queryByName(String name) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BankCategoryEntity::getName, (Object)name);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List bankCategoryEntities = this.bankCategoryMapper.selectList((Wrapper)lambda);
        return bankCategoryEntities;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap indexMap = new HashMap();
            ArrayList<BankCategoryVO> voList = new ArrayList<BankCategoryVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                String warnType = "";
                BankCategoryVO bankCategoryVO = new BankCategoryVO();
                bankCategoryVO.setId(IdWorker.getId());
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                    lambda.eq(BankCategoryEntity::getCode, datas.get(0));
                    lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    List bankCategoryEntities = this.bankCategoryMapper.selectList((Wrapper)lambda);
                    if (CollectionUtils.isEmpty((Collection)bankCategoryEntities)) {
                        bankCategoryVO.setCode(String.valueOf(datas.get(0)));
                    } else {
                        warnType = warnType + "[\u94f6\u884c\u5206\u7c7b\u7f16\u7801\u91cd\u590d]";
                        bankCategoryVO.setCode((String)datas.get(0));
                    }
                } else {
                    CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                    if (codeBatchByRuleCode.isSuccess()) {
                        bankCategoryVO.setCode((String)codeBatchByRuleCode.getData());
                    } else {
                        bankCategoryVO.setCode(String.valueOf(new Date().getTime()));
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    bankCategoryVO.setName(null);
                    warnType = warnType + "[\u94f6\u884c\u7c7b\u522b\u540d\u79f0\u4e3a\u7a7a]";
                } else {
                    bankCategoryVO.setName((String)datas.get(1));
                }
                bankCategoryVO.setWarnType(warnType);
                bankCategoryVO.setMemo((String)datas.get(2));
                bankCategoryVO.setRowState("add");
                voList.add(bankCategoryVO);
            }
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(voList)) {
                voList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankCategoryVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<BankCategoryEntity> list = new ArrayList<BankCategoryEntity>();
        for (BankCategoryVO importVO : importVOS) {
            BankCategoryEntity bank = (BankCategoryEntity)((Object)BeanMapper.map((Object)((Object)importVO), BankCategoryEntity.class));
            list.add(bank);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            super.saveOrUpdateBatch(list);
        }
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }
}

