/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.service.ICooperateService;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DESUtils;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BillShareHelper {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICooperateService cooperateService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;
    private final String WEI_XIN_BACK_URL = "/ejc-supbusiness-web/commomsupbusiness/getBillShareLink";
    private final String WX_CODE_URL = "https://open.weixin.qq.com/connect/qrconnect?appid=wx270b19a26de3997e&scope=snsapi_login&response_type=code&redirect_uri=";

    public CommonResponse<JSONObject> getBillShareLink(Long billId, String billTypeCode, String supplierId, String h5FrontUrl, String wxFrontUrl) {
        JSONObject resp = new JSONObject();
        QueryParam param = new QueryParam();
        List list = this.ejcCloudSystemService.queryList(param, false);
        if (ListUtil.isEmpty((List)list)) {
            return CommonResponse.error((String)"\u76ca\u4f01\u8054\u516c\u6709\u4e91\u5e73\u53f0\u5185\u7684\u7cfb\u7edf\u6807\u8bc6\u7f16\u7801 \u5c1a\u672a\u914d\u7f6e\uff01");
        }
        String ejcCloudSystemId = ((EjcCloudSystemEntity)((Object)list.get(0))).getCode();
        try {
            CooperateVO cooperateVO = this.cooperateService.queryCooperateByBillTypeCode(billTypeCode);
            if (null == cooperateVO) {
                this.logger.error("\u5355\u636e\u7c7b\u578b-{}\u672a\u8fdb\u884c\u534f\u540c\u5206\u4eab\u914d\u7f6e\uff0c{}", (Object)billTypeCode);
                return CommonResponse.error((String)"\u5355\u636e\u7c7b\u578b\u672a\u8fdb\u884c\u534f\u540c\u5206\u4eab\u914d\u7f6e, \u8bf7\u8bbe\u7f6e\u534f\u540c\u4fe1\u606f\u540e\u5728\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (1 != cooperateVO.getShareFlag()) {
                this.logger.error("\u5355\u636e\u7c7b\u578b-{}\u534f\u540c\u914d\u4e0d\u652f\u6301\u534f\u540c\u5206\u4eab\uff0c{}", (Object)billTypeCode, (Object)JSONObject.toJSONString((Object)((Object)cooperateVO)));
                return CommonResponse.error((String)"\u83b7\u53d6\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff0c\u8be5\u5355\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u534f\u540c\u5206\u4eab\uff01");
            }
            CommonResponse cacheData2 = this.systemDataPushService.getAuthInfoBySupplierId(supplierId);
            this.logger.info("\u83b7\u53d6\u5230\u4f9b\u5e94\u5546id-{}\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)supplierId, (Object)cacheData2.isSuccess());
            if (!cacheData2.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u5230\u4f9b\u5e94\u5546id-{}\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a", (Object)supplierId);
                return CommonResponse.error((String)"\u83b7\u53d6\u5206\u4eab\u8fde\u63a5\u5931\u8d25, \u67e5\u627e\u4f9b\u5e94\u5546\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            SupplierVO supplierVO = this.supplierService.queryDetail(Long.valueOf(supplierId));
            if (null == supplierVO) {
                this.logger.error("\u7cfb\u7edf\u4e2d\u672a\u627e\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546id-{}\u4fe1\u606f", (Object)supplierId);
                return CommonResponse.error((String)"\u83b7\u53d6\u5206\u4eab\u8fde\u63a5\u5931\u8d25, \u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            String serverAddr = ((JSONObject)cacheData2.getData()).get((Object)"appHost").toString();
            this.logger.info("\u4f9b\u5e94\u5546id-{}\u4f01\u4e1a\u670d\u52a1url\u5730\u5740\uff1a{}", (Object)supplierId, (Object)serverAddr);
            Long timeInLong = this.getAeadTime(cooperateVO.getEffectiveHour());
            String weakFlag = cooperateVO.getWeakFlag().toString();
            StringBuffer sp = new StringBuffer("id=");
            sp.append(billId).append("&tl=").append(timeInLong).append("&supplierTenant=").append(supplierVO.getTenant()).append("&weakFlag=").append(weakFlag);
            StringBuffer wxParam = new StringBuffer(sp);
            wxParam.append("&frontUrl=").append(URLEncoder.encode(h5FrontUrl, "UTF-8"));
            String secret = DESUtils.encrypt((String)(sp.toString() + "&supplierId=" + supplierId));
            sp.append("&secret=").append(URLEncoder.encode(secret, "utf-8"));
            String wxUrlSecret = DESUtils.encrypt((String)(wxParam.toString() + "&supplierId=" + supplierId));
            wxParam.append("&secret=").append(URLEncoder.encode(wxUrlSecret, "utf-8"));
            String wxShareLink = StringUtils.isNotBlank((CharSequence)wxFrontUrl) ? wxFrontUrl : "/ejc-supbusiness-web/commomsupbusiness/getBillShareLink";
            String wxRedirectUrl = URLEncoder.encode(serverAddr + wxShareLink + "?" + wxParam.append("&ejcCloudSystemId=").append(ejcCloudSystemId).toString(), "UTF-8");
            resp.put("mobileH5Url", (Object)(serverAddr + h5FrontUrl + "?" + sp.toString()));
            resp.put("mobileWxUrl", (Object)(serverAddr + h5FrontUrl + "?" + sp.toString()));
            resp.put("timeout", (Object)timeInLong);
            this.logger.info("\u4f9b\u5e94\u5546id-{}\u5355\u636e\u5206\u4eaburl\u5730\u5740\uff1a{}", (Object)resp.toString());
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u53c2\u6570billId-{},billTypeCode-{},supplierId-{},h5FrontUrl-{}, wxFrontUrl-{}\u751f\u6210\u5206\u4eab\u94fe\u63a5\u5f02\u5e38", new Object[]{billId, billTypeCode, supplierId, h5FrontUrl, wxFrontUrl, e});
            return CommonResponse.error((String)"\u751f\u6210\u5206\u4eab\u94fe\u63a5\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u5206\u4eab\u8fde\u63a5\u6210\u529f\uff01", (Object)resp);
    }

    private Long getAeadTime(BigDecimal efectiveHours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, efectiveHours.intValue());
        return cal.getTimeInMillis();
    }
}

