package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.SubjectProjectHystrix;
import com.ejianc.foundation.share.vo.SubjectProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 设备rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = SubjectProjectHystrix.class)
public interface IShareSubjectProjectApi {
	/**
	 * 根据项目主键和名称集合查列表
	 * @param projectId
	 * @param nameList
	 * @return
	 */
	@GetMapping("/api/shareSubjectProjectApi/queryListByProjAndCodes")
	CommonResponse<List<SubjectProjectVO>> queryListByProjAndCodes(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "nameList", required = false) List<String> nameList);
}
