package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.BankHystrix;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 项目立项rpc服务
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = BankHystrix.class)
public interface IBankApi {


    /**
     * @param
     * @param
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @date: 2022/3/28
     */
    @PostMapping(value = "/api/bankApi/pushToBank")
    CommonResponse<String> pushToBank(@RequestBody byte[] supplyByte);


    /***
     * @param bankAccountVO
     * @param1 supplierId 供应商id 或 supplierIds 供应商id集合
     * @param2 supplierName 供应商名称
     * @param3 enabled 是否启用 1启用 0停用
     * @param4 defaultFlag 是否默认 1是 0否
     * @description: 通过条件获取银行账户
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.support.vo.BankAccountVO>>
     * @author songlx
     * @date: 2022/5/24
     */
    @PostMapping(value = "/api/bankApi/getBankAccountsByCondition")
    CommonResponse<List<BankAccountVO>> getBankAccountsByCondition(@RequestBody BankAccountVO bankAccountVO);


    /**
     * 批量插入/更新银行账户
     */
    @PostMapping(value = "/api/bankApi/batchSaveOrUpdBankAccount")
    CommonResponse<String> batchSaveOrUpdBankAccount(@RequestBody List<BankAccountVO> bankAccountVOS);

}
