package com.ejianc.foundation.share.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商-分包负责人解绑实体
 * 
 * @author generator
 * 
 */
public class SubLeaderUnbindVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 单据编码
    private Long subLeaderId; // 分包负责人ID
    private String subLeaderName; // 分包负责人名称
    private String subLeaderIdNum; // 分包负责人身份证号码
    private String subLeaderPhone; // 分包负责人手机号
    private Long supplierId; // 供应商ID
    private String supplierCode; // 供应商编码
    private String supplierName; // 供应商名称
    private Long employeeId; // 经办人ID
    private String employeeName; // 经办人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate; // 经办日期
    private String unbindMemo; // 解除说明
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bindDate; // 绑定日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date unbindDate; // 解绑日期
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="share-supplier-sub-leader")
    public Long getSubLeaderId() {
        return subLeaderId;
    }
    @ReferDeserialTransfer
    public void setSubLeaderId(Long subLeaderId) {
        this.subLeaderId = subLeaderId;
    }
    public String getSubLeaderName() {
        return subLeaderName;
    }

    public void setSubLeaderName(String subLeaderName) {
        this.subLeaderName = subLeaderName;
    }
    public String getSubLeaderIdNum() {
        return subLeaderIdNum;
    }

    public void setSubLeaderIdNum(String subLeaderIdNum) {
        this.subLeaderIdNum = subLeaderIdNum;
    }
    public String getSubLeaderPhone() {
        return subLeaderPhone;
    }

    public void setSubLeaderPhone(String subLeaderPhone) {
        this.subLeaderPhone = subLeaderPhone;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }


    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public String getUnbindMemo() {
        return unbindMemo;
    }

    public void setUnbindMemo(String unbindMemo) {
        this.unbindMemo = unbindMemo;
    }
    public Date getBindDate() {
        return bindDate;
    }

    public void setBindDate(Date bindDate) {
        this.bindDate = bindDate;
    }
    public Date getUnbindDate() {
        return unbindDate;
    }

    public void setUnbindDate(Date unbindDate) {
        this.unbindDate = unbindDate;
    }
    
}
