package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ProjectSetExHystrix;
import com.ejianc.foundation.share.vo.ProjectSetExPoolVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 仅用于郑州一建项目数据处理
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = ProjectSetExHystrix.class)
public interface IProjectSetExApi {

    /**
     * 推送生成项目
     * 会根据项目编码进行判断是否新增
     *
     */
    @PostMapping(value = "/api/projectExApi/pushProject")
    public CommonResponse<String> pushProject(@RequestBody List<ProjectSetExPoolVO> projects);



}
