package com.ejianc.foundation.share.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商类别变更-证件子表
 * 
 * @author generator
 * 
 */
public class SupplierTypeChangeCertsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String certCode; // 证件编号
    private String certName; // 证件名称
    private Long certId; // 证件名称id
    private String awardOrg; // 发证单位
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date awardDate; // 授予时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date timeValidity; // 有效期至
    private Long pid; // 主表id
    

    public String getCertCode() {
        return certCode;
    }

    public void setCertCode(String certCode) {
        this.certCode = certCode;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    @ReferSerialTransfer(referCode="supplier_the_scope")
    public Long getCertId() {
        return certId;
    }

    /**
     * 证件名称id
     */
    @ReferDeserialTransfer
    public void setCertId(Long certId) {
        this.certId = certId;
    }
    public String getAwardOrg() {
        return awardOrg;
    }

    public void setAwardOrg(String awardOrg) {
        this.awardOrg = awardOrg;
    }
    public Date getAwardDate() {
        return awardDate;
    }

    public void setAwardDate(Date awardDate) {
        this.awardDate = awardDate;
    }
    public Date getTimeValidity() {
        return timeValidity;
    }

    public void setTimeValidity(Date timeValidity) {
        this.timeValidity = timeValidity;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
