package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.PriceDepotPowerSetHystrix;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 项目立项rpc服务
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = PriceDepotPowerSetHystrix.class)
public interface IPriceDepotPowerSetApi {

    @GetMapping(value = "/api/priceDepotPowerSet/queryOrgList")
    CommonResponse<List<Long>> queryOrgList(@RequestParam(value = "orgId") Long orgId);

}
