package com.ejianc.foundation.supplierChange.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 供应商变更-证书实体
 * 
 * @author generator
 * 
 */
public class CertsChangeVO extends BaseVO {

    private static final long serialVersionUID = 3022499450002460890L;

    private String certCode; // 证件编号
    private String certName; // 证件名称
    private Long certId; // 证件名称id
    private String awardOrg; // 发证单位
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date awardDate; // 授予时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date timeValidity; // 有效期至
    private Long pid; // 主表id
    private Long sourceSupplierId; // 源供应商Id
    private Long sourceSupplierCertId; // 源供应商证件Id


    /**
     * 证件编号
     */
    public String getCertCode() {
        return certCode;
    }

    /**
     * 证件编号
     */
    public void setCertCode(String certCode) {
        this.certCode = certCode;
    }
    /**
     * 证件名称
     */
    public String getCertName() {
        return certName;
    }

    /**
     * 证件名称
     */
    public void setCertName(String certName) {
        this.certName = certName;
    }
    /**
     * 证件名称id
     */
    @ReferSerialTransfer(referCode="supplier_the_scope")
    public Long getCertId() {
        return certId;
    }

    /**
     * 证件名称id
     */
    @ReferDeserialTransfer
    public void setCertId(Long certId) {
        this.certId = certId;
    }
    /**
     * 发证单位
     */
    public String getAwardOrg() {
        return awardOrg;
    }

    /**
     * 发证单位
     */
    public void setAwardOrg(String awardOrg) {
        this.awardOrg = awardOrg;
    }
    /**
     * 授予时间
     */
    public java.util.Date getAwardDate() {
        return awardDate;
    }

    /**
     * 授予时间
     */
    public void setAwardDate(java.util.Date awardDate) {
        this.awardDate = awardDate;
    }
    /**
     * 有效期至
     */
    public Date getTimeValidity() {
        return timeValidity;
    }
    /**
     * 有效期至
     */
    public void setTimeValidity(Date timeValidity) {
        this.timeValidity = timeValidity;
    }

    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(Long sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }
    public Long getSourceSupplierCertId() {
        return sourceSupplierCertId;
    }

    public void setSourceSupplierCertId(Long sourceSupplierCertId) {
        this.sourceSupplierCertId = sourceSupplierCertId;
    }
    
}
