package com.ejianc.foundation.share.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 供应商、客户、客商
 * @date 2022/5/21
 */
public enum SupplierFlagEnum {

    供应商(1, "供应商"),
    客户(2, "客户"),
    客商(3, "客商");

    private Integer code;

    private String name;



    private static Map<String, String> enumMap;

    static {
        enumMap = new HashMap<>();
        for (ProjectBusinessStatusEnum enumVal : ProjectBusinessStatusEnum.values()) {
            enumMap.put(enumVal.getBusinessStatus(), enumVal.getBusinessStatusName());
        }
    }

    public static String getNameByCode(String code) {
        return enumMap.get(code);
    }


    SupplierFlagEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
