package com.ejianc.foundation.share.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.foundation.share.vo.SupplierTypeChangeExpertVO;
import com.ejianc.foundation.share.vo.SupplierTypeChangeSubLeaderVO;

/**
 * 供应商类别变更
 * 
 * @author generator
 * 
 */
public class SupplierTypeChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 变更编号
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long supplyId; // 供应商ID
    private String supplyCode; // 供应商编码
    private String supplyName; // 供应商名称
    private String socialCreditCode; // 统一社会信用代码
    private String taxPayerIdentifier; // 纳税人识别号
    private String beforeChangeType; // 变更前类别
    private String changeType; // 变更后类别
    private String mainBusinessCategory; // 主营类别
    private String mainBusinessCategoryName; // 主营类别
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Integer investigate; // 是否考察，0-否，1-是

    private String memo; // 备注
    private Long operateId; // 操作人id
    private String operateName; // 操作人名称
    private Date operateTime; // 操作时间
    private Long accessId; // 供应商准入ID
    private String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    private String supplyTypeName; // 供方类别名称

    private String materialContentId; // 物资供货内容id
    private String materialContent; // 物资供货内容名称
    private String materialMemo; // 物资补充描述
    private String equipmentContentId; // 设备供货内容id
    private String equipmentContent; // 设备供货内容
    private String equipmentMemo; // 设备补充描述
    private String majorContentId; // 专业分包供货内容id
    private String majorContent; // 专业分包供货内容
    private String majorMemo; // 专业分包补充描述
    private String laborContentId; // 劳务分包供货内容id
    private String laborContent; // 劳务分包供货内容
    private String laborMemo; // 劳务分包补充描述
    private String otherContentId; // 其他供货内容id
    private String otherContent; // 其他供货内容
    private String otherMemo; // 其他补充描述
    private String revolvMaterialContentId; // 周转材供货内容id
    private String revolvMaterialContent; // 周转材供货内容
    private String revolvMaterialMemo; // 周转材补充描述
    private String consultContentId; // 咨询供货内容id
    private String consultContent; // 咨询供货内容
    private String consultMemo; // 咨询补充描述
    private String billStateName; // 单据状态名称

    private List<SupplierTypeChangeExpertVO> expertList = new ArrayList<>(); // 供应商类别变更-专家子表
    private List<SupplierTypeChangeSubLeaderVO> subLeaderList = new ArrayList<>(); // 供应商类别变更-分包负责人实体
    private List<SupplierTypeChangeCertsVO> certs = new ArrayList<>(); // 供应商准入---证书

    public List<SupplierTypeChangeCertsVO> getCerts() {
        return certs;
    }

    public void setCerts(List<SupplierTypeChangeCertsVO> certs) {
        this.certs = certs;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplyId() {
        return supplyId;
    }
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyCode() {
        return supplyCode;
    }

    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getTaxPayerIdentifier() {
        return taxPayerIdentifier;
    }

    public void setTaxPayerIdentifier(String taxPayerIdentifier) {
        this.taxPayerIdentifier = taxPayerIdentifier;
    }
    public String getBeforeChangeType() {
        return beforeChangeType;
    }

    public void setBeforeChangeType(String beforeChangeType) {
        this.beforeChangeType = beforeChangeType;
    }
    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
    public String getMainBusinessCategory() {
        return mainBusinessCategory;
    }

    public void setMainBusinessCategory(String mainBusinessCategory) {
        this.mainBusinessCategory = mainBusinessCategory;
    }

    public String getMainBusinessCategoryName() {
        return mainBusinessCategoryName;
    }

    public void setMainBusinessCategoryName(String mainBusinessCategoryName) {
        this.mainBusinessCategoryName = mainBusinessCategoryName;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getInvestigate() {
        return investigate;
    }

    public void setInvestigate(Integer investigate) {
        this.investigate = investigate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getOperateId() {
        return operateId;
    }
    @ReferDeserialTransfer
    public void setOperateId(Long operateId) {
        this.operateId = operateId;
    }
    public String getOperateName() {
        return operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }
    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }
    public Long getAccessId() {
        return accessId;
    }

    public void setAccessId(Long accessId) {
        this.accessId = accessId;
    }
    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getMaterialContentId() {
        return materialContentId;
    }

    @ReferDeserialTransfer
    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }
    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }
    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getEquipmentContentId() {
        return equipmentContentId;
    }

    @ReferDeserialTransfer
    public void setEquipmentContentId(String equipmentContentId) {
        this.equipmentContentId = equipmentContentId;
    }
    public String getEquipmentContent() {
        return equipmentContent;
    }

    public void setEquipmentContent(String equipmentContent) {
        this.equipmentContent = equipmentContent;
    }
    public String getEquipmentMemo() {
        return equipmentMemo;
    }

    public void setEquipmentMemo(String equipmentMemo) {
        this.equipmentMemo = equipmentMemo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getMajorContentId() {
        return majorContentId;
    }

    @ReferDeserialTransfer
    public void setMajorContentId(String majorContentId) {
        this.majorContentId = majorContentId;
    }
    public String getMajorContent() {
        return majorContent;
    }

    public void setMajorContent(String majorContent) {
        this.majorContent = majorContent;
    }
    public String getMajorMemo() {
        return majorMemo;
    }

    public void setMajorMemo(String majorMemo) {
        this.majorMemo = majorMemo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getLaborContentId() {
        return laborContentId;
    }

    @ReferDeserialTransfer
    public void setLaborContentId(String laborContentId) {
        this.laborContentId = laborContentId;
    }
    public String getLaborContent() {
        return laborContent;
    }

    public void setLaborContent(String laborContent) {
        this.laborContent = laborContent;
    }
    public String getLaborMemo() {
        return laborMemo;
    }

    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getOtherContentId() {
        return otherContentId;
    }

    @ReferDeserialTransfer
    public void setOtherContentId(String otherContentId) {
        this.otherContentId = otherContentId;
    }
    public String getOtherContent() {
        return otherContent;
    }

    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }
    public String getOtherMemo() {
        return otherMemo;
    }

    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getRevolvMaterialContentId() {
        return revolvMaterialContentId;
    }

    @ReferDeserialTransfer
    public void setRevolvMaterialContentId(String revolvMaterialContentId) {
        this.revolvMaterialContentId = revolvMaterialContentId;
    }
    public String getRevolvMaterialContent() {
        return revolvMaterialContent;
    }

    public void setRevolvMaterialContent(String revolvMaterialContent) {
        this.revolvMaterialContent = revolvMaterialContent;
    }
    public String getRevolvMaterialMemo() {
        return revolvMaterialMemo;
    }

    public void setRevolvMaterialMemo(String revolvMaterialMemo) {
        this.revolvMaterialMemo = revolvMaterialMemo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getConsultContentId() {
        return consultContentId;
    }

    @ReferDeserialTransfer
    public void setConsultContentId(String consultContentId) {
        this.consultContentId = consultContentId;
    }
    public String getConsultContent() {
        return consultContent;
    }

    public void setConsultContent(String consultContent) {
        this.consultContent = consultContent;
    }
    public String getConsultMemo() {
        return consultMemo;
    }

    public void setConsultMemo(String consultMemo) {
        this.consultMemo = consultMemo;
    }

    public List<SupplierTypeChangeExpertVO> getExpertList() {
        return expertList;
    }

    public void setExpertList(List<SupplierTypeChangeExpertVO> expertList) {
        this.expertList = expertList;
    }

    public List<SupplierTypeChangeSubLeaderVO> getSubLeaderList() {
        return subLeaderList;
    }

    public void setSubLeaderList(List<SupplierTypeChangeSubLeaderVO> subLeaderList) {
        this.subLeaderList = subLeaderList;
    }
}
