package com.ejianc.foundation.supplier.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.supplier.hystrix.ZDSShareSupplierHystrix;
import com.ejianc.foundation.supplier.vo.ShareSupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ZDSShareSupplierHystrix.class)
public interface IZDSShareSupplierApi {


    /**
     * 根据供应商来源Id，获取供应商信息
     */
    @GetMapping(value = "/api/zds/shareSupplierApi/getOneBySourceId")
    CommonResponse<ShareSupplierVO> getOneBySourceId(@RequestParam("sourceId") String sourceId, @RequestParam(required = false) String supplierType);

    /**
     * 根据供应商来源Id，获取供应商信息
     */
    @PostMapping(value = "/api/zds/shareSupplierApi/getAllBySourceIds")
    CommonResponse<List<ShareSupplierVO>> getAllBySourceIds(@RequestBody JSONObject params);

    /**
     * 根据供应商编码，获取供应商信息
     */
    @GetMapping(value = "/api/zds/shareSupplierApi/getOneByCode")
    CommonResponse<ShareSupplierVO> getOneByCode(@RequestParam("code") String code);

    /**
     * 根据供应商编码，获取供应商信息
     */
    @PostMapping(value = "/api/zds/shareSupplierApi/getAllByCodes")
    CommonResponse<List<ShareSupplierVO>> getAllByCodes(@RequestBody List<String> codes);

    /**
     * 根据租户Id获取对应供应商信息
     *
     * @param tenantId
     * @return
     */
    @GetMapping(value = "/api/zds/shareSupplierApi/getByTenantId")
    CommonResponse<ShareSupplierVO> getByTenantId(@RequestParam Long tenantId);

    /**
     * 根据租户Ids获取对应供应商信息列表
     *
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "/api/zds/shareSupplierApi/getByTenantIds")
    CommonResponse<List<ShareSupplierVO>> getByTenantIds(@RequestParam List<Long> tenantIds);

}
