package com.ejianc.foundation.share.vo;

import java.util.ArrayList;
import java.util.Date;
import java.math.*;
import java.util.List;

import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 大企业客户
 * 
 * @author generator
 * 
 */
public class CustomerProVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 供方编码
    private String name; // 供方名称
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    private Long categoryId; // 客户分类ID
    private String socialCreditCode; // 统一社会信用代码
    private String legal; // 法定代表人
    private String businessScope; // 经营范围
    private Integer enabled; // 合作不合作（1：合作 ， 0：不合作）
    private String area; // 地区
    private String address; // 详细地址
    private String telephone; // 客户电话
    private String bankName; // 开户行名称
    private String bankAccount; // 户名
    private String bankCode; // 开户行卡号
    private String description; // 客户描述
    private String sourceId; // 来源id
    private String systemId; // 系统id
    private String province; // 省份
    private String city; // 市
    private String region; // 区县
    private Long orgId; // 所属组织id
    private Long insideOrgId; // 内部客商--来源组织id(青岛市政）
    private String orgName; // 所属组织名称
    private Long enterpriseNature; // 企业性质id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerTime; // 注册日期
    private String taxPayerIdentifier; // 纳税人识别号
    private BigDecimal registeredCapital; // 注册资金
    private String legalPhone; // 法人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issuingTime; // 发证时间
    private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
    private Integer supplierFlag; // 是否属于物资，0-否，1-是
    private Integer subFlag; // 是否属于分包，0-否，1-是
    private Integer blacklistFlag; // 是否黑名单，0-否，1-是
    private Long operateId; // 操作人id
    private String operateName; // 操作人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date operateTime; // 操作时间
    private Long operateOrgId; // 操作人所属组织id
    private String operateOrgName; // 操作人所属组织名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date blTime; // 营业执照有效期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date splTime; // 安全生产许可证有效期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qcTime; // 资质证书有效期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date scTime; // 安全证有效期
    private Integer redlistFlag; // 是否红名单，0-否，1-是
    private String categoryName; // 分类名称
    private Long accessId; // 供应商准入ID
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    private String supplyTypeName; // 供方类别名称
    private String personal; // 个人：p，企业：e
    private String groupInOrOut; // 集团内外：内in，外out
    private String applyOrgName; // 申请单位
    private Long applyOrgId; // 申请单位id
    private String enterpriseNatureName; // 企业性质名称
    private Long registerCountryId; // 注册国家id
    private String registerCountryName; // 注册国家名称
    private String legalPerson; // 法人代表/别名
    private String areaName; // 所在地区
    private Integer inOrOut; // 国内外：1国内，2国外
    private Long gradeId; // 供应商等级
    private String gradeName; // 供应商等级
    private String memo; // 准入说明
    private Integer coordination; // 是否协同
    private BigDecimal turnover; // 年营业额
    private Integer inException; // 是否异常
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exceptionEndDate; // 异常结束时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lastCoDate; // 最近合作时间
    private Long punishType; // 供应商状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date punishDate; // 处置日期
    private String punishApplyOrg; // 处置申请单位
    private String punishApplyPerson; // 处置申请人
    private String punishOldGrade; // 处置原等级
    private String punishGrade; // 处置等级
    private String punishMemo; // 处置理由
    private String businessPerson; // 业务代表
    private String businessPhone; // 业务代表电话
    private Boolean insideOrg; // 内外部客商 true：内部，false：外部
    private String mainBusinessCategory; // 主营类别
    private String distributerOrManufactor; // 厂家/经销商
    private String taxpayerType; // 纳税人类型
    private String billingAddress; // 开票地址
    private String billingPhone; // 开票电话
    private Long bankAccountId; // 开票银行
    private String bankAccountName; // 开票银行
    private String bankAccountCode; // 开票银行账户

    private Long customType;//客户分类
    private String customTypeName;//客户分类名称
    private Long parentId;//上级客户

    private List<BankAccountVO> banks = new ArrayList<>(); // 银行信息
    private List<CustomerLinkerVO> linkmen = new ArrayList<>(); // 客户联系人

    public List<BankAccountVO> getBanks() {
        return banks;
    }

    public void setBanks(List<BankAccountVO> banks) {
        this.banks = banks;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }

    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getInsideOrgId() {
        return insideOrgId;
    }

    public void setInsideOrgId(Long insideOrgId) {
        this.insideOrgId = insideOrgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    @ReferDeserialTransfer
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }
    public String getTaxPayerIdentifier() {
        return taxPayerIdentifier;
    }

    public void setTaxPayerIdentifier(String taxPayerIdentifier) {
        this.taxPayerIdentifier = taxPayerIdentifier;
    }
    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public Date getIssuingTime() {
        return issuingTime;
    }

    public void setIssuingTime(Date issuingTime) {
        this.issuingTime = issuingTime;
    }
    public Integer getEvaluationGrade() {
        return evaluationGrade;
    }

    public void setEvaluationGrade(Integer evaluationGrade) {
        this.evaluationGrade = evaluationGrade;
    }
    public Integer getSupplierFlag() {
        return supplierFlag;
    }

    public void setSupplierFlag(Integer supplierFlag) {
        this.supplierFlag = supplierFlag;
    }
    public Integer getSubFlag() {
        return subFlag;
    }

    public void setSubFlag(Integer subFlag) {
        this.subFlag = subFlag;
    }
    public Integer getBlacklistFlag() {
        return blacklistFlag;
    }

    public void setBlacklistFlag(Integer blacklistFlag) {
        this.blacklistFlag = blacklistFlag;
    }
    public Long getOperateId() {
        return operateId;
    }

    public void setOperateId(Long operateId) {
        this.operateId = operateId;
    }
    public String getOperateName() {
        return operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }
    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }
    public Long getOperateOrgId() {
        return operateOrgId;
    }

    public void setOperateOrgId(Long operateOrgId) {
        this.operateOrgId = operateOrgId;
    }
    public String getOperateOrgName() {
        return operateOrgName;
    }

    public void setOperateOrgName(String operateOrgName) {
        this.operateOrgName = operateOrgName;
    }
    public Date getBlTime() {
        return blTime;
    }

    public void setBlTime(Date blTime) {
        this.blTime = blTime;
    }
    public Date getSplTime() {
        return splTime;
    }

    public void setSplTime(Date splTime) {
        this.splTime = splTime;
    }
    public Date getQcTime() {
        return qcTime;
    }

    public void setQcTime(Date qcTime) {
        this.qcTime = qcTime;
    }
    public Date getScTime() {
        return scTime;
    }

    public void setScTime(Date scTime) {
        this.scTime = scTime;
    }
    public Integer getRedlistFlag() {
        return redlistFlag;
    }

    public void setRedlistFlag(Integer redlistFlag) {
        this.redlistFlag = redlistFlag;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Long getAccessId() {
        return accessId;
    }

    public void setAccessId(Long accessId) {
        this.accessId = accessId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }
    public String getGroupInOrOut() {
        return groupInOrOut;
    }

    public void setGroupInOrOut(String groupInOrOut) {
        this.groupInOrOut = groupInOrOut;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    @ReferDeserialTransfer
    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public Integer getInOrOut() {
        return inOrOut;
    }

    public void setInOrOut(Integer inOrOut) {
        this.inOrOut = inOrOut;
    }
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getCoordination() {
        return coordination;
    }

    public void setCoordination(Integer coordination) {
        this.coordination = coordination;
    }
    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }
    public Integer getInException() {
        return inException;
    }

    public void setInException(Integer inException) {
        this.inException = inException;
    }
    public Date getExceptionEndDate() {
        return exceptionEndDate;
    }

    public void setExceptionEndDate(Date exceptionEndDate) {
        this.exceptionEndDate = exceptionEndDate;
    }
    public Date getLastCoDate() {
        return lastCoDate;
    }

    public void setLastCoDate(Date lastCoDate) {
        this.lastCoDate = lastCoDate;
    }
    public Long getPunishType() {
        return punishType;
    }

    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    public Date getPunishDate() {
        return punishDate;
    }

    public void setPunishDate(Date punishDate) {
        this.punishDate = punishDate;
    }
    public String getPunishApplyOrg() {
        return punishApplyOrg;
    }

    public void setPunishApplyOrg(String punishApplyOrg) {
        this.punishApplyOrg = punishApplyOrg;
    }
    public String getPunishApplyPerson() {
        return punishApplyPerson;
    }

    public void setPunishApplyPerson(String punishApplyPerson) {
        this.punishApplyPerson = punishApplyPerson;
    }
    public String getPunishOldGrade() {
        return punishOldGrade;
    }

    public void setPunishOldGrade(String punishOldGrade) {
        this.punishOldGrade = punishOldGrade;
    }
    public String getPunishGrade() {
        return punishGrade;
    }

    public void setPunishGrade(String punishGrade) {
        this.punishGrade = punishGrade;
    }
    public String getPunishMemo() {
        return punishMemo;
    }

    public void setPunishMemo(String punishMemo) {
        this.punishMemo = punishMemo;
    }
    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }
    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }
    public Boolean getInsideOrg() {
        return insideOrg;
    }

    public void setInsideOrg(Boolean insideOrg) {
        this.insideOrg = insideOrg;
    }
    public String getMainBusinessCategory() {
        return mainBusinessCategory;
    }

    public void setMainBusinessCategory(String mainBusinessCategory) {
        this.mainBusinessCategory = mainBusinessCategory;
    }
    public String getDistributerOrManufactor() {
        return distributerOrManufactor;
    }

    public void setDistributerOrManufactor(String distributerOrManufactor) {
        this.distributerOrManufactor = distributerOrManufactor;
    }
    public String getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(String taxpayerType) {
        this.taxpayerType = taxpayerType;
    }
    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }
    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }

    @ReferSerialTransfer(referCode="support-bank")
    public Long getBankAccountId() {
        return bankAccountId;
    }
    @ReferDeserialTransfer
    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }
    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }
    public String getBankAccountCode() {
        return bankAccountCode;
    }

    public void setBankAccountCode(String bankAccountCode) {
        this.bankAccountCode = bankAccountCode;
    }

    public Long getCustomType() {
        return customType;
    }

    public void setCustomType(Long customType) {
        this.customType = customType;
    }

    public String getCustomTypeName() {
        return customTypeName;
    }

    public void setCustomTypeName(String customTypeName) {
        this.customTypeName = customTypeName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getParentId() {
        return parentId;
    }

    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public List<CustomerLinkerVO> getLinkmen() {
        return linkmen;
    }

    public void setLinkmen(List<CustomerLinkerVO> linkmen) {
        this.linkmen = linkmen;
    }
}
