/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component
public class FileUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String baseHost;
    private static final FileUtil instance;

    private FileUtil() {
    }

    public static FileUtil getInstance() {
        return instance;
    }

    public Map<String, InputStream> batchDownFileFlow(List<Long> fileIds, boolean mustSuc) {
        HashMap<String, InputStream> resp;
        block4: {
            resp = new HashMap<String, InputStream>();
            String url = baseHost + "ejc-file-web/attachment/batchdownflow";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("fileIds", StringUtils.join(fileIds, (String)","));
            String downloadFileStr = null;
            try {
                downloadFileStr = ReferHttpClientUtils.getAndHeader((String)url, params);
                this.logger.info("\u6839\u636eurl-{}\uff0c\u53c2\u6570-{}", (Object)url, (Object)JSONObject.toJSONString(params));
                Map respMap = (Map)JSONObject.parseObject((String)downloadFileStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                if (null == respMap.get("data")) {
                    this.logger.error("\u6839\u636e\u9644\u4ef6Id\u4e0b\u8f7d\u9644\u4ef6\u4e3a\u7a7a", (Object)JSONObject.toJSONString(fileIds));
                    return new HashMap<String, InputStream>();
                }
                JSONObject json = JSON.parseObject((String)((String)respMap.get("data")));
                for (String key : json.keySet()) {
                    resp.put(key, new ByteArrayInputStream(json.getBytes(key)));
                }
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u9644\u4ef6Id\u4e0b\u8f7d\u9644\u4ef6\u5f02\u5e38-{}", (Object)JSONObject.toJSONString(fileIds), (Object)e);
                if (!mustSuc) break block4;
                throw new BusinessException("\u4e0b\u8f7d\u9644\u4ef6\u5f02\u5e38\uff0c", (Throwable)e);
            }
        }
        return resp;
    }

    public Map<String, List<Long>> handleReqFile(MultipartHttpServletRequest multipartRequest, Map<String, String> fileSourceTypeMapping, String billType, String authority, String sourceId) {
        HashMap<String, List<Long>> resp = new HashMap<String, List<Long>>();
        Map fileMap = multipartRequest.getFileMap();
        HashMap fileMaps = new HashMap();
        HashMap<String, InputStream> fileItemMap = null;
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile mf = (MultipartFile)entity.getValue();
                String originalFilename = mf.getOriginalFilename();
                if (null == fileMaps.get(fileSourceTypeMapping.get(originalFilename))) {
                    fileMaps.put(fileSourceTypeMapping.get(originalFilename), new HashMap());
                }
                fileItemMap = new HashMap<String, InputStream>();
                fileItemMap.put(originalFilename, mf.getInputStream());
                ((Map)fileMaps.get(fileSourceTypeMapping.get(originalFilename))).put(originalFilename, fileItemMap);
            }
            fileMaps.keySet().forEach(sourceType -> {
                List<AttachmentVO> attachs = this.upFile((String)sourceType, sourceId, billType, (Map)fileMaps.get(sourceType), authority);
                if (CollectionUtils.isNotEmpty(attachs)) {
                    resp.put((String)sourceType, attachs.stream().map(item -> item.getId()).collect(Collectors.toList()));
                }
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u5c06\u8bf7\u6c42\u4e2d\u9644\u4ef6\u4fe1\u606f\u4e0a\u4f20\u81f3\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38: ", (Throwable)e);
        }
        return resp;
    }

    public List<AttachmentVO> upFile(String sourceType, String sourceId, String billType, Map<String, Map<String, InputStream>> files, String authority) {
        this.logger.info("\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f--" + authority);
        List<Object> attachs = new ArrayList<AttachmentVO>();
        if (StringUtils.isNotBlank((CharSequence)authority)) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                params.put("sourceId", sourceId);
            }
            if (StringUtils.isNotBlank((CharSequence)sourceType)) {
                params.put("sourceType", sourceType);
            }
            params.put("billType", billType);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", authority);
            try {
                this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u53c2\u6570\uff1aparams-{}, headers-{}, \u6587\u4ef6\u6570\u91cf-{}", new Object[]{params, headers, files.size()});
                String fileUploadRespStr = HttpTookit.postFiles((String)(baseHost + "ejc-file-web/attachment/upload"), params, headers, files, (Integer)10000, (Integer)10000);
                this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)fileUploadRespStr);
                CommonResponse attachmentResp = (CommonResponse)JSONObject.parseObject((String)fileUploadRespStr, CommonResponse.class);
                this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u4fe1\u606f: {}", (Object)JSONObject.toJSONString((Object)attachmentResp));
                if (!attachmentResp.isSuccess()) {
                    this.logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, \u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, attachmentResp.getMsg()});
                    return null;
                }
                attachs = JSONObject.parseArray((String)JSONObject.toJSONString((Object)attachmentResp.getData()), AttachmentVO.class);
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, \u539f\u56e0\uff1a", new Object[]{sourceId, sourceType, billType, e});
                return null;
            }
            this.logger.info("\u6a21\u677f\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString(attachs));
        }
        return attachs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream, String fileName) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;
        try {
            HttpResponse res;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key2 = null;
                for (String key2 : headers.keySet()) {
                    post.addHeader(key2, headers.get(key2));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    public String getBaseHost() {
        return baseHost;
    }

    @Value(value="${common.env.base-host}")
    public void setBaseHost(String baseHost) {
        FileUtil.baseHost = baseHost;
    }

    static {
        instance = new FileUtil();
    }
}

