package com.ejianc.foundation.share.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.share.hystrix.ShareEquipmentHystrix;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 设备rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareEquipmentHystrix.class)
public interface IShareEquipmentApi {

    /**
     * 根据编码查询设备详情
     * @Author liyongjia
     * @param code
     * @return
     */
	@GetMapping(value = "/api/shareEquipmentApi/queryEquipmentByCode")
	CommonResponse<EquipmentVO> queryEquipmentByCode(@RequestParam(value = "code") String code);
}
