package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ShareCooperateHystrix;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 物资rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareCooperateHystrix.class)
public interface IShareCooperateApi {


	/**
	 * 根据模块id 查询 协同设置列表
	 *
	 * @param moduleId
	 * @return List<CooperateVO>
	 */
	@GetMapping(value = "/api/shareCooperateApi/queryCooperateListByModuleId")
	public CommonResponse<List<CooperateVO>> queryCooperateListByModuleId(@RequestParam(value = "moduleId") Long moduleId);

	/**
	 * 根据模块单据编号 查询 协同设置
	 *
	 * @param billTypeCode
	 * @return CooperateVO
	 */
	@GetMapping(value = "/api/shareCooperateApi/queryCooperateBybillTypeCode")
	public CommonResponse<CooperateVO> queryCooperateBybillTypeCode(@RequestParam(value = "billTypeCode") String billTypeCode);

}
