package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ProSupplierHystrix;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * 大企业供应商rpc服务
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ProSupplierHystrix.class)
public interface IProSupplierApi {

	/**
	 * 供应商准入推送，生成企业供应商 适用于供应商本体推送，包括物资设备供应商、劳务分包供应商 分包负责人准入使用本方法下面方法
	 *
	 * @return supplyByte 是SupplierVO的json字符串生成的字节数组
	 */
	@PostMapping(value = "/api/shareSupplierApi/pushSupplierToShare")
	public CommonResponse<String> pushSupplierToShare(@RequestBody  byte[] supplyByte);

	/**
	 *  判断纳税人识别号、身份证号是否重复
	 *
	 * @return
	 */
	@PostMapping(value = "/api/shareSupplierApi/judgeTaxpayerNumIsRepeat")
	public CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam  String taxpayerNum, @RequestParam String personal);


	/**
	 * 分包负责人准入推送，生成供应商企业负责人 适用于分包负责人准入推送 ；物资设备供应商、劳务分包供应商请使用上面的方法
	 *
	 * @return
	 */
	@PostMapping(value = "/api/shareSupplierApi/pushSubLeadersToShare")
	public CommonResponse<String> pushSubLeadersToShare(@RequestBody SubleadersPushVO pushVO);

	/**
	 * 供应商处置更新供应商库
	 */
	@PostMapping(value = "/api/shareSupplierApi/punishSupplier")
	public CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO);

	/**
	 * 供应商 评级更新供应商库
	 * @param supplierId 供应商id
	 * @param gradeId 评定等级id
	 * @param gradeName 评定等级名称
	 */
	@GetMapping(value = "/api/shareSupplierApi/upgradeSupplier")
	public CommonResponse<String> upgradeSupplier(@RequestParam("supplierId") Long supplierId,
												  @RequestParam("gradeId") Long gradeId,
												  @RequestParam("gradeName") String gradeName);


	/**
	 * 获取本私有化平台在 益企联公有云平台内的系统标识编码
	 */
	@GetMapping(value = "/api/shareSupplierApi/getEjcCloudSystemCode")
	public CommonResponse<String> getEjcCloudSystemCode();


}
